<?php
/**
 * This template is used for displaying the dashboard auto top up form.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/dashboard/auto-topup-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class="wal-dashboard-auto-topup-content-wrapper wal-dashboard-content-wrapper">
	<?php
	/**
	 * This hook is used to display the extra content before auto top-up form wrapper.
	 * 
	 * @since 1.0
	 */
	do_action('wal_before_auto_topup_form_wrapper');
	?>
	<div class="wal-auto-topup-form-wrapper">

		<div class="wal-dashboard-notices-wrapper">
			<?php wal_print_dashboard_notices(); ?>
		</div>

		<?php if ($show) : ?>        
			<form method="POST" action="" class="wal-auto-topup-form">

				<div class="wal-auto-topup-form-content">
					<?php if (!$authorized) { ?>
						<p>
							<label><?php echo esc_html(get_option('wal_module_dashboard_auto_topup_amount_label')); ?></label>

							<?php if (!empty($topup_predefined_amounts)) { ?>
								<select id="wal_auto_topup_amount" name="wal_auto_topup_predefined_amount" >
									<?php foreach ($topup_predefined_amounts as $topup) { ?>                                       
										<option value="<?php echo esc_attr(wal_convert_price($topup)); ?>"><?php echo wp_kses_post(wal_convert_price_by_currency($topup)); ?></option>
									<?php } ?>
									<option value="user-defined"><?php esc_html_e('Select custom amount..', 'wallet-for-woocommerce'); ?></option>
								</select>
							<?php } ?>
							<span class="wal-auto-topup-custom-currency"><?php echo esc_attr(get_woocommerce_currency_symbol()) ; ?></span>
							<input type="number" name="wal_auto_topup_custom_amount" step="<?php echo esc_attr(wal_number_field_step_value()); ?>" min="<?php echo esc_attr($topup_min_amount); ?>" max="<?php echo esc_attr($topup_max_amount); ?>" value=""/>
							
						</p>

						<p>
							<label><?php echo esc_html(get_option('wal_module_dashboard_auto_topup_threshold_amount_label')); ?></label>

							<?php if (!empty($threshold_predefined_amounts)) { ?>
								<select id="wal_auto_topup_threshold_amount" name="wal_auto_topup_threshold_predefined_amount" >
									<?php foreach ($threshold_predefined_amounts as $topup) { ?>
										<option value="<?php echo esc_attr(wal_convert_price($topup)); ?>"><?php echo wp_kses_post(wal_convert_price_by_currency($topup)); ?></option>
									<?php } ?>
									<option value="user-defined"><?php esc_html_e('Select custom amount..', 'wallet-for-woocommerce'); ?></option>
								</select>
							<?php } ?>
							<span class="wal-auto-topup-threshold-custom-currency"><?php echo esc_attr(get_woocommerce_currency_symbol()) ; ?></span>
							<input type="number" name="wal_auto_topup_threshold_custom_amount" step="<?php echo esc_attr(wal_number_field_step_value()); ?>" min="<?php echo esc_attr($min_threshold_amount); ?>" max="<?php echo esc_attr($max_threshold_amount); ?>" value=""/>
						</p>  

						<?php if ('yes' === get_option('wal_module_auto_topup_terms_and_conditions')) { ?>
							<div class="wal_auto_iagree"><p><input type="checkbox" id="wal_auto_topup_agree" name="wal_auto_topup_agree" value="yes"/><?php echo wp_kses_post(str_replace('[wallet_auto_topup_terms]', get_option('wal_module_auto_topup_terms_and_conditions_url'), get_option('wal_module_auto_topup_terms_and_conditions_content'))); ?></p></div>
						<?php } ?>

						<div class="wal-auto-topup-form-actions">
							<input type="submit" class="wal-auto-topup-form-btn" name="wal-auto-topup-pay-and-authorize" value="<?php echo esc_attr(get_option('wal_module_dashboard_auto_topup_and_authorize_button_label')); ?>" >
							<input type="submit" class="wal-auto-topup-form-btn" name="wal-auto-topup-authorize" value="<?php echo esc_attr(get_option('wal_module_dashboard_auto_topup_authorize_button_label')); ?>" >
							<input type="hidden" name="wal-auto-topup-nonce" value="<?php echo esc_attr(wp_create_nonce('wal-auto-topup')); ?>" />
						</div>
					<?php } else { ?>
						<p>
							<label><?php echo esc_html(get_option('wal_module_dashboard_authorized_auto_topup_amount_label')); ?></label>
							<span><b><?php echo wp_kses_post(wal_convert_price_by_currency($auto_topup->get_topup_amount())); ?></b></span>
						</p>
						<p>                           
							<label><?php echo esc_html(get_option('wal_module_dashboard_authorized_auto_topup_threshold_amount_label')); ?></label>
							<span><b><?php echo wp_kses_post(wal_convert_price_by_currency($auto_topup->get_threshold_amount())); ?></b></span>
						</p>
						<p>
							<input type="submit" class="wal-cancel-auto-topup-btn" value="<?php echo esc_html(get_option('wal_module_dashboard_cancel_auto_topup_authorized_button_label')); ?>"/>
							<input type="hidden" name="wal_cancel_auto_topup" value="<?php echo esc_attr($auto_topup->get_id()); ?>"/>
							<input type="hidden" name="wal-auto-topup-nonce" value="<?php echo esc_attr(wp_create_nonce('wal-auto-topup')); ?>" />
						</p>       
					<?php } ?>
				</div>
			</form>
		<?php endif; ?>
	</div>
	<?php
	/**
	 * This hook is used to display the extra content after auto top-up form wrapper.
	 * 
	 * @since 1.0
	 */
	do_action('wal_after_auto_topup_form_wrapper');
	?>
</div>
