<?php
/**
 * This template displays the dashboard overview.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/dashboard/overview.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
$overview_data = wal_wallet_overview_data() ;
?>
<div class="wal-dashboard-overview-content-wrapper wal-dashboard-content-wrapper">
	<div class="wal-dashboard-overview-content">
		<?php
		if ( wal_check_is_array( $overview_data ) ) :
			foreach ( $overview_data as $key => $data ) :
				if ( 'expired_total' == $key && 'yes' == get_option('wal_general_hide_expiry_column')) :
					continue;
				endif;
				
				?>
				<div class="wal-dashboard-overview-data wal-dashboard-overview-<?php echo esc_attr( str_replace( '_' , '-' , $key ) ) ; ?>">
					<p><label><?php echo esc_html( $data[ 'label' ] ) ; ?></label></p>
					<p><span><?php echo wp_kses_post( $data[ 'value' ] ) ; ?></label></span></p>
				</div>
				<?php
			endforeach ;
		endif ;
		?>
	</div>
</div>
<?php
