<?php
/**
 * This template is used for displaying the dashboard activity.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/dashboard/activity.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

foreach ($transaction_log_ids as $transaction_log_id) :
	$transaction_log = wal_get_transaction_log($transaction_log_id);

	if (!$transaction_log->exists()) {
		continue;
	}
	?>
	<tr>
		<?php foreach ($columns as $column_key => $column_name) : ?>
			<td data-title="<?php echo esc_attr($column_name); ?>">
				<?php
				switch ($column_key) :

					case 'event':
						echo wp_kses_post($transaction_log->get_formatted_event_message());
						break;

					case 'amount':
						$class_name = ( 'wal_debit' == $transaction_log->get_status() ) ? 'wal-debit-amount' : 'wal-credit-amount';
						$increment = ( 'wal_debit' == $transaction_log->get_status() ) ? '-' : '+';

						echo '<span class="' . esc_attr($class_name) . '">' . esc_html($increment);                                                
						echo wp_kses_post(wal_price(wal_convert_price($transaction_log->get_amount()), array( 'currency' => $transaction_log->get_currency() )));
						echo '</span>';
						break;

					case 'total':
						echo wp_kses_post(wal_price(wal_convert_price($transaction_log->get_total()), array( 'currency' => $transaction_log->get_currency() )));
						break;

					case 'date':
						echo wp_kses_post($transaction_log->get_formatted_created_date());
						break;

					default:
						/**
						 * This hook is used to display the content for activity custom column.
						 * 
						 * @since 1.0
						 */
						do_action('wal_dashboard_activity_column_' . $column_key, $column_key, $transaction_log);
						break;
				endswitch;
				?>
			</td>

		<?php endforeach; ?>
	</tr>
	<?php
endforeach;
