<?php
/**
 * This template displays the Dashboard.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/dashboard.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

global $wal_current_endpoint ;

/**
 * This hook is used to display the extra content before dashboard wrapper.
 * 
 * @since 1.0
 */
do_action( 'wal_before_dashboard_wrapper' ) ;
?>
<div class="wal-dashboard-wrapper">

	<div class="wal-dashboard-notices-wrapper">
		<?php wal_print_dashboard_notices() ; ?>
	</div>

	<div class="wal-dashboard-profile-wrapper">
		<div class="wal-dashboard-profile-image">
			<?php echo get_avatar( get_current_user_id(), 128 ) ; ?>
		</div>

		<div class="wal-dashboard-profile-data">
			<p class="wal-dashboard-user-name">
				<label><?php echo wp_kses_post( WAL_Current_User_Wallet::get_user_name() ) ; ?></label>
			</p>

			<p class="wal-dashboard-user-email">
				<label><?php echo wp_kses_post( WAL_Current_User_Wallet::get_user_email() ) ; ?></label>
			</p>

			<p class="wal-dashboard-available-balance">
				<label><?php echo esc_html( wal_dashboard_balance_label() ) ; ?></label>
				<span><?php echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ; ?></span>
			</p>

			<?php if ('yes' != get_option('wal_general_hide_expiry_column')) { ?>
				<p>
					<label><?php echo esc_html( wal_dashboard_expiry_date_label() ) ; ?></label>
					<span><?php echo wp_kses_post( WAL_Current_User_Wallet::get_expiry_date( true ) ) ; ?></span>
				</p>
			<?php } ?>
		</div>

		<div class="wal-dashboard-profile-status">
			<?php echo wp_kses_post( wal_display_post_status( WAL_Current_User_Wallet::get_status() ) ) ; ?>
		</div>
	</div>

	<div class="wal-dashboard-menu-wrapper">

		<div class="wal-dashboard-menus">
			<ul class="wal-dashboard-menu-links">
				<?php 
				foreach ( wal_dashboard_menus() as $endpoint => $dashboard_menu ) :
					$wal_submenu = isset( $dashboard_menu['submenus'] ) && wal_check_is_array( $dashboard_menu['submenus'] );
					?>
					<li class="wal-dashboard-menu-link">
						<a class="<?php echo esc_attr( wal_dashboard_menu_item_classes( $endpoint, $wal_current_endpoint, $dashboard_menu ) ) ; ?>" 
							<?php if ( ! $wal_submenu ) : ?>
								href="<?php echo esc_url( wal_dashboard_menu_endpoint_url( $endpoint ) ) ; ?>"
							<?php endif; ?>>
						<?php echo esc_html( $dashboard_menu[ 'name' ] ) ; ?></a>
						<?php
						if ( $wal_submenu ) :
							?>
							<ul class="wal-dashboard-submenu-links">
								<?php foreach ( $dashboard_menu[ 'submenus' ] as $submenu_endpoint => $sub_menu ) : ?>
									<li class="wal-dashboard-submenu-link">
										<a class="<?php echo esc_attr( wal_dashboard_submenu_item_classes( $submenu_endpoint ) ) ; ?>" href="<?php echo esc_url( wal_dashboard_menu_endpoint_url( $submenu_endpoint ) ) ; ?>"><?php echo esc_html( $sub_menu[ 'name' ] ) ; ?></a>
									</li>
									<?php
								endforeach ;
								?>
							</ul>
							<?php
						endif ;
						?>
					</li>
				<?php endforeach ; ?>
			</ul>
		</div>

		<div class="wal-dashboard-menu-content">
			<?php
			/**
			 * This hook is used to display the content for dashboard current menu.
			 * 
			 * @hooked WAL_Dashboard_Handler::render_overview - 10
			 * @hooked WAL_Dashboard_Handler::render_activity - 10
			 * @hooked WAL_Dashboard_Handler::render_topup - 10
			 * @hooked WAL_Auto_Topup_Module->render - 10
			 * @hooked WAL_Fund_Transfer_Module->transactions_menu_content - 10
			 * @hooked WAL_Fund_Transfer_Module->fund_transfer_menu_content - 10
			 * @hooked WAL_Fund_Transfer_Module->fund_request_menu_content - 10
			 * @hooked WAL_Gift_Voucher_Module->gift_voucher_menu_content - 10
			 * @since 1.0
			 */
			do_action( 'wal_dashboard_menu_content_' . $wal_current_endpoint ) ;
			/**
			 * This hook is used to display the extra content for menu.
			 * 
			 * @since 1.0
			 */
			do_action( 'wal_dashboard_menu_content' ) ;
			?>
		</div>

	</div>
</div>
<?php
/**
 * This hook is used to display the extra content after dashboard wrapper.
 * 
 * @since 1.0
 */
do_action( 'wal_after_dashboard_wrapper' ) ;
