<?php
/**
 * This template displays the checkout partial fund usage.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/checkout-partial-fund.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

/**
 * This hook is used to display the extra content before partial fund usage wrapper in the checkout.
 * 
 * @since 1.0
 */
do_action( 'wal_before_checkout_partial_fund_usage_wrapper' ) ;
?>
<div class="wal-checkout-partial-fund-usage-wrapper wal-redeem-wallet-fund-form-wrapper">
	<div class="woocommerce-info">
		<?php echo wp_kses_post( wal_get_checkout_partial_usage_title_label() ) ; ?>
		<a class="wal-checkout-partial-fund-usage-link" href="javascript:void(0)"><?php echo wp_kses_post( wal_get_checkout_partial_usage_link_label() ) ; ?></a>
	</div>

	<div class="wal-checkout-partial-fund-usage-content wal-hide">
		<p class="wal-partial-fund-usage-balance"><?php echo wp_kses_post( wal_get_partial_usage_balance_message() ) ; ?></p>
		<?php
		$usage_limit = wal_get_maximum_fund_usage_limit(); 
		$available_balance = WAL_Current_User_Wallet::get_balance();
		if ( ! empty($usage_limit) && $available_balance > $usage_limit && $usage_limit < wal_get_wc_cart_total()) {
			?>
			<p class="wal-partial-fund-usage-limit"><?php echo wp_kses_post( wal_get_partial_fund_usage_limit_message() ) ; ?></p>
			<?php
		}
		?>
		<div class="wal-checkout-partial-fund-usage-form">
			<label><?php echo wp_kses_post( wal_get_partial_usage_title_label() ) ; ?></label>
			<input type="number" step="<?php echo esc_attr( wal_number_field_step_value() ) ; ?>" min="0" 
				   class="wal-number-field wal-checkout-partial-fund-usage-amount wal-partial-fund-usage-amount" value="" 
				   placeholder="<?php echo esc_attr( wal_get_partial_usage_placeholder_label() ) ; ?>"/>
			<button type="button" class="button button-primary wal-checkout-partial-fund-usage-btn"><?php echo wp_kses_post( wal_get_partial_usage_button_label() ) ; ?></button>
		</div>
	</div>
</div>
<?php
/**
 * This hook is used to display the extra content after partial fund usage wrapper in the checkout.
 * 
 * @since 1.0
 */
do_action( 'wal_after_checkout_partial_fund_usage_wrapper' ) ;
