<?php
/**
 * This template displays the cart partial fund usage.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/cart-partial-fund.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

/**
 * This hook is used to display the extra content before partial fund usage wrapper in the cart.
 * 
 * @since 1.0
 */
do_action( 'wal_before_cart_partial_fund_usage_wrapper' ) ;
?>
<div class="wal-cart-partial-fund-usage-wrapper wal-redeem-wallet-fund-form-wrapper">
	<p class="wal-partial-fund-usage-balance"><?php echo wp_kses_post( wal_get_partial_usage_balance_message() ) ; ?></p>
	<?php
	$usage_limit = wal_get_maximum_fund_usage_limit(); 
	$available_balance = WAL_Current_User_Wallet::get_balance();
	if ( ! empty($usage_limit) && $available_balance > $usage_limit && $usage_limit < wal_get_wc_cart_total()) {
		?>
		<p class="wal-partial-fund-usage-limit"><?php echo wp_kses_post( wal_get_partial_fund_usage_limit_message() ) ; ?></p>
		<?php
	}
	?>
		
	<div class="wal-cart-partial-fund-usage-content">
		<label><?php echo wp_kses_post( wal_get_partial_usage_title_label() ) ; ?></label>
		<input type="number" step="<?php echo esc_attr( wal_number_field_step_value() ) ; ?>" min="0" 
			   class="wal-number-field wal-cart-partial-fund-usage-amount wal-partial-fund-usage-amount"
			   placeholder="<?php echo esc_attr( wal_get_partial_usage_placeholder_label() ) ; ?>"/>
		<button type="button" class="button button-primary wal-cart-partial-fund-usage-btn"><?php echo wp_kses_post( wal_get_partial_usage_button_label() ) ; ?></button>
	</div>
</div>
<?php
/**
 * This hook is used to display the extra content after partial fund usage wrapper in the cart.
 * 
 * @since 1.0
 */
do_action( 'wal_after_cart_partial_fund_usage_wrapper' ) ;
