<?php
/**
 * This template displays the wallet fee wrapper in the cart/checkout block.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/block/wallet-fee-wrapper.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 * 
 * @since 3.7.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class='wal-block-components-totals-fees wc-block-components-totals-item wc-block-components-totals-fees wc-block-components-totals-fees__'<?php echo esc_attr($fee->id); ?>>
	<span class='wc-block-components-totals-item__label'><?php echo esc_attr($fee->name); ?></span>
	<span class="wc-block-formatted-money-amount wc-block-components-formatted-money-amount wc-block-components-totals-item__value"><?php echo wp_kses_post(wal_price($fee->total)); ?>
		<a href='javascript:void(0)' class='wal-block-remove-wallet-fund_link'><?php echo esc_html(wal_get_partial_usage_remove_button_label()); ?></a>
	</span>
</div>
<?php
