<?php
/**
 * This template displays the redeem wallet fund form in the checkout block.
 *
 * This template can be overridden by copying it to yourtheme/wallet-for-woocommerce/block/checkout-redeem-wallet-fund-form.php
 *
 * To maintain compatibility, Wallet for WooCommerce will update the template files and you have to copy the updated files to your theme
 * 
 * @since 3.7.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * This hook is used to display the extra content before redeem wallet fund form in the checkout block.
 * 
 * @since 3.7.0
 */
do_action('wal_before_checkout_block_redeem_wallet_fund_form_wrapper');
?>
<div class='wal-checkout-block-redeem-wallet-fund-form_wrapper wal-block-redeem-wallet-fund-form_wrapper'>
	<div class='wal-block-wallet-details_wrapper'>
		<p class='wal-block-wallet-balance_label'><?php echo wp_kses_post(wal_get_partial_usage_balance_message()); ?></p>
		<p class='wal-block-wallet-maximum-usage_label'><?php echo wp_kses_post(wal_get_partial_fund_usage_limit_message()); ?></p>
	</div>
	<div class='wal-block-redeem-wallet-fund-form_fields wc-block-components-text-input'>
		<input type='text' value='' 
			   class='wal-number-field wal-block-redeem-wallet-fund wc-block-components-text-input' 
			   placeholder="<?php echo esc_attr(wal_get_partial_usage_placeholder_label()); ?>"/>
		<div class='wc-block-components-validation-error'></div>
		<button type='button' disabled='disabled' class='components-button wc-block-components-button wp-element-button wal-block-redeem-wallet-fund_button'><?php echo wp_kses_post(wal_get_partial_usage_button_label()); ?></button>
	</div>
</div>
<?php
/**
 * This hook is used to display the extra content after redeem wallet fund form in the checkout block.
 * 
 * @since 3.7.0
 */
do_action('wal_after_checkout_block_redeem_wallet_fund_form_wrapper');
