<?php

/**
 * Widget Instances Class.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Widget_Instances' ) ) {

	/**
	 * Class.
	 * */
	class WAL_Widget_Instances {

		/**
		 * Widgets.
		 * 
		 * @var array
		 * */
		private static $widgets = array() ;

		/**
		 * Get the widgets.
		 * 
		 * @return array
		 * */
		public static function get_widgets() {

			if ( ! self::$widgets ) {
				self::load_widgets() ;
			}

			return self::$widgets ;
		}

		/**
		 * Load all widgets.
		 * */
		public static function load_widgets() {

			$default_widget_classes = array(
				'wal-topup-form'     => 'WAL_Topup_Form_Widget',
				'wal-wallet-balance' => 'WAL_Wallet_Balance_Widget',
					) ;

			foreach ( $default_widget_classes as $file_name => $widget_class ) {

				// Include widget file.
				include 'class-' . $file_name . '.php' ;

				//Add widget.
				self::add_widget( $widget_class ) ;
			}

			add_action( 'widgets_init' , array( __CLASS__, 'register_widgets' ) ) ;
		}

		/**
		 * Register the widget classes.
		 * */
		public static function register_widgets() {
			$widget_classes = self::get_widget_classes() ;

			if ( ! wal_check_is_array( $widget_classes ) ) {
				return '' ;
			}

			foreach ( $widget_classes as $widget_class ) {

				// Register a widget. 
				register_widget( $widget_class ) ;
			}
		}

		/**
		 * Add a widget.
		 * */
		public static function add_widget( $class ) {
			self::$widgets[] = $class ;

			return self::$widgets ;
		}

		/**
		 * Get the widget classes.
		 * */
		public static function get_widget_classes() {
			return self::$widgets ;
		}
	}

}
