<?php

/**
 * Widget - Wallet Balance.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Wallet_Balance_Widget' ) ) {

	/**
	 * Class.
	 * */
	class WAL_Wallet_Balance_Widget extends WC_Widget {

		/**
		 * Class Constructor.
		 * */
		public function __construct() {

			$this->widget_cssclass    = 'woocommerce wal_wallet_balance' ;
			$this->widget_description = __( 'Display the wallet balance', 'wallet-for-woocommerce' ) ;
			$this->widget_id          = 'wal_wallet_balance' ;
			$this->widget_name        = __( 'Wallet Balance', 'wallet-for-woocommerce' ) ;

			$this->populate_settings() ;

			parent::__construct() ;
		}

		/**
		 * Populate settings.
		 *          
		 * @return array
		 * */
		private function populate_settings() {
			/**
			 * This hook is used to alter the wallet balance widget settings.
			 * 
			 * @since 1.0
			 */
			$this->settings = apply_filters( 'wal_wallet_balance_widget_settings', array(
				'title' => array(
					'type'  => 'text',
					'std'   => __( 'Wallet Balance', 'wallet-for-woocommerce' ),
					'label' => __( 'Title', 'wallet-for-woocommerce' ),
				),
					) ) ;
		}

		/**
		 * Output the widget.
		 *
		 * */
		public function widget( $args, $instance ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			if ( ! isset( $instance[ 'title' ] ) ) {
				$instance[ 'title' ] = __( 'Wallet Balance', 'wallet-for-woocommerce' ) ;
			}

			$this->widget_start( $args, $instance ) ;

			echo wp_kses_post( wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ) ;

			$this->widget_end( $args ) ;
		}
	}

}
