<?php

/**
 * Widget - Top-up Form.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Topup_Form_Widget' ) ) {

	/**
	 * Class.
	 * */
	class WAL_Topup_Form_Widget extends WC_Widget {

		/**
		 * Class Constructor.
		 * */
		public function __construct() {

			$this->widget_cssclass    = 'woocommerce wal_topup_form' ;
			$this->widget_description = __( 'Display the wallet top-up form', 'wallet-for-woocommerce' ) ;
			$this->widget_id          = 'wal_topup_form' ;
			$this->widget_name        = __( 'Wallet Top-up Form', 'wallet-for-woocommerce' ) ;

			$this->populate_settings() ;

			parent::__construct() ;
		}

		/**
		 * Populate settings.
		 *          
		 * @return array
		 * */
		private function populate_settings() {
			/**
			 * This hook is used to alter the top-up form widget settings.
			 * 
			 * @since 1.0
			 */
			$this->settings = apply_filters( 'wal_topup_form_widget_settings', array(
				'title' => array(
					'type'  => 'text',
					'std'   => __( 'Wallet Top-up Form', 'wallet-for-woocommerce' ),
					'label' => __( 'Title', 'wallet-for-woocommerce' ),
				),
					) ) ;
		}

		/**
		 * Output the widget.
		 *
		 * */
		public function widget( $args, $instance ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			if ( ! isset( $instance[ 'title' ] ) ) {
				$instance[ 'title' ] = __( 'Wallet Top-up Form', 'wallet-for-woocommerce' ) ;
			}

			$this->widget_start( $args, $instance ) ;

			WAL_Topup_Handler::render() ;

			$this->widget_end( $args ) ;
		}
	}

}
