<?php

/**
 * Template functions.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!function_exists('wal_get_template')) {

	/**
	 * Get the other templates from themes.
	 * 
	 * @return void
	 */
	function wal_get_template( $template_name, $args = array() ) {

		wc_get_template($template_name, $args, WAL_FOLDER_NAME . '/', WAL()->templates());
	}

}

if (!function_exists('wal_get_template_html')) {

	/**
	 *  Like wal_get_template, but returns the HTML instead of outputting.
	 *
	 *  @return mixed
	 */
	function wal_get_template_html( $template_name, $args = array() ) {

		ob_start();
		wal_get_template($template_name, $args);
		return ob_get_clean();
	}

}

if (!function_exists('wal_get_wallet_myaccount_menu_endpoint')) {

	/**
	 * Get the endpoint for wallet MyAccount menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_wallet_myaccount_menu_endpoint() {
		/**
		 * This hook is used to alert the MyAccount wallet menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_wallet_myaccount_menu_endpoint', get_option('wal_localization_myaccount_wallet_menu_endpoint'));
	}

}

if (!function_exists('wal_get_wallet_myaccount_menu_name_label')) {

	/**
	 * Get the label for wallet MyAccount menu name.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_wallet_myaccount_menu_name_label() {
		/**
		 * This hook is used to alert the MyAccount wallet menu name label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_wallet_myaccount_menu_name_label', get_option('wal_localization_myaccount_wallet_menu_name_label'));
	}

}

if (!function_exists('wal_myaccount_wallet_balance_label')) {

	/**
	 * Get the label for MyAccount wallet balance.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_myaccount_wallet_balance_label() {
		/**
		 * This hook is used to alert the MyAccount wallet balance label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_myaccount_wallet_balance_label', get_option('wal_localization_myaccount_wallet_balance_label'));
	}

}

if (!function_exists('wal_myaccount_wallet_status_label')) {

	/**
	 * Get the label for MyAccount wallet status.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_myaccount_wallet_status_label() {
		/**
		 * This hook is used to alert the MyAccount wallet status label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_myaccount_wallet_status_label', get_option('wal_localization_myaccount_wallet_status_label'));
	}

}

if (!function_exists('wal_myaccount_wallet_usage_total_label')) {

	/**
	 * Get the label for MyAccount wallet usage total.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_myaccount_wallet_usage_total_label() {
		/**
		 * This hook is used to alert the MyAccount wallet usage total label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_myaccount_wallet_usage_total_label', get_option('wal_localization_myaccount_wallet_usage_total_label'));
	}

}

if (!function_exists('wal_myaccount_wallet_expiry_date_label')) {

	/**
	 * Get the label for MyAccount wallet expiry date.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_myaccount_wallet_expiry_date_label() {
		/**
		 * This hook is used to alert the MyAccount wallet expiry date label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_myaccount_wallet_expiry_date_label', get_option('wal_localization_myaccount_wallet_expiry_date_label'));
	}

}

if (!function_exists('wal_myaccount_wallet_details')) {

	/**
	 * MyAccount wallet details.
	 * 
	 * @return array.
	 * 
	 * */
	function wal_myaccount_wallet_details() {
		$wallet_details = array(
			'status' => array(
				'label' => wal_myaccount_wallet_status_label(),
				'value' => wal_display_post_status(WAL_Current_User_Wallet::get_status()),
			),
			'total_amount' => array(
				'label' => wal_myaccount_wallet_usage_total_label(),
				'value' => wal_convert_price_by_currency(WAL_Current_User_Wallet::get_usage_total()),
			),
		);

		if ('yes' != get_option('wal_general_hide_expiry_column')) {
			$wallet_details['expiry_date'] = array(
				'label' => wal_myaccount_wallet_expiry_date_label(),
				'value' => WAL_Current_User_Wallet::get_expiry_date(true),
			);
		}
		
		/**
		 * This hook is used to alert the MyAccount wallet details.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_myaccount_wallet_details', $wallet_details);
	}

}

if (!function_exists('wal_get_partial_usage_title_label')) {

	/**
	 * Get the label for partial usage title.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_usage_title_label() {
		/**
		 * This hook is used to alert the partial usage title label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_title_label', get_option('wal_localization_partial_fund_title_label'));
	}

}

if (!function_exists('wal_get_partial_usage_placeholder_label')) {

	/**
	 * Get the label for partial usage placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_usage_placeholder_label() {
		/**
		 * This hook is used to alert the partial usage placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_placeholder_label', get_option('wal_localization_partial_fund_placeholder_label'));
	}

}

if (!function_exists('wal_get_partial_usage_button_label')) {

	/**
	 * Get the label for partial usage button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_usage_button_label() {
		/**
		 * This hook is used to alert the partial usage button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_button_label', get_option('wal_localization_partial_fund_button_label'));
	}

}

if (!function_exists('wal_get_partial_usage_remove_button_label')) {

	/**
	 * Get the label for partial usage remove button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_usage_remove_button_label() {
		/**
		 * This hook is used to alert the partial usage remove button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_remove_button_label', get_option('wal_localization_partial_fund_remove_button_label'));
	}

}

if (!function_exists('wal_get_checkout_partial_usage_title_label')) {

	/**
	 * Get the label for checkout partial usage title.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_checkout_partial_usage_title_label() {
		/**
		 * This hook is used to alert the partial usage title label in the checkout.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_checkout_partial_usage_title_label', get_option('wal_localization_checkout_partial_fund_title_label'));
	}

}

if (!function_exists('wal_get_checkout_partial_usage_link_label')) {

	/**
	 * Get the label for checkout partial usage link.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_checkout_partial_usage_link_label() {
		/**
		 * This hook is used to alert the partial usage link label in the checkout.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_checkout_partial_usage_link_label', get_option('wal_localization_checkout_partial_fund_link_label'));
	}

}

if (!function_exists('wal_partial_usage_fee_title_label')) {

	/**
	 * Get the label for partial usage fee title.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_partial_usage_fee_title_label() {
		/**
		 * This hook is used to alert the partial usage fee title label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_fee_title_label', get_option('wal_localization_partial_fund_fee_title_label'));
	}

}

if (!function_exists('wal_get_topup_title_label')) {

	/**
	 * Get the label for topup title.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_topup_title_label() {
		/**
		 * This hook is used to alert the topup title label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_topup_title_label', get_option('wal_localization_topup_title_label'));
	}

}

if (!function_exists('wal_get_topup_placeholder_label')) {

	/**
	 * Get the label for top-up placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_topup_placeholder_label() {
		/**
		 * This hook is used to alert the topup placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_topup_placeholder_label', get_option('wal_localization_topup_placeholder_label'));
	}

}

if (!function_exists('wal_get_topup_button_label')) {

	/**
	 * Get the label for topup button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_topup_button_label() {
		/**
		 * This hook is used to alert the topup button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_topup_button_label', get_option('wal_localization_topup_button_label'));
	}

}

if (!function_exists('wal_dashboard_balance_label')) {

	/**
	 * Get the label for dashboard balance.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_dashboard_balance_label() {
		/**
		 * This hook is used to alert the dashboard balance label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_dashboard_balance_label', get_option('wal_localization_dashboard_balance_label'));
	}

}

if (!function_exists('wal_dashboard_expiry_date_label')) {

	/**
	 * Get the label for dashboard expiry date.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_dashboard_expiry_date_label() {
		/**
		 * This hook is used to alert the dashboard expiry date label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_dashboard_expiry_date_label', get_option('wal_localization_dashboard_expiry_date_label'));
	}

}

if (!function_exists('wal_transaction_log_columns')) {

	/**
	 * Get the transaction log columns.
	 *
	 *  @return array
	 */
	function wal_transaction_log_columns() {
		/**
		 * This hook is used to alert the transaction log columns.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_transaction_log_columns', array(
			'event' => get_option('wal_localization_wallet_activity_event_label'),
			'amount' => get_option('wal_localization_wallet_activity_amount_label'),
			'total' => get_option('wal_localization_wallet_activity_total_label'),
			'date' => get_option('wal_localization_wallet_activity_date_label'),
		));
	}

}

if (!function_exists('wal_transaction_logs_pagination_count')) {

	/**
	 * Get the transaction logs pagination count.
	 *
	 *  @return string
	 */
	function wal_transaction_logs_pagination_count() {
		/**
		 * This hook is used to alert the transaction log pagination count.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_transaction_logs_pagination_count', get_option('wal_general_transaction_logs_pagination_count', 5));
	}

}

if (!function_exists('wal_get_pagination_classes')) {

	/**
	 * Get the pagination classes.
	 *
	 *  @return array
	 */
	function wal_get_pagination_classes( $page_no, $current_page ) {
		$classes = array( 'wal_pagination', 'wal_pagination_' . $page_no );

		if ($current_page == $page_no) {
			$classes[] = 'current';
		}
		/**
		 * This hook is used to alert the pagination classes.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_pagination_classes', $classes, $page_no, $current_page);
	}

}

if (!function_exists('wal_get_pagination_number')) {

	/**
	 * Get the pagination number.
	 *
	 *  @return string
	 */
	function wal_get_pagination_number( $start, $page_count, $current_page ) {
		$page_no = false;
		if ($current_page <= $page_count && $start <= $page_count) {
			$page_no = $start;
		} else if ($current_page > $page_count) {
			$overall_count = $current_page - $page_count + $start;
			if ($overall_count <= $current_page) {
				$page_no = $overall_count;
			}
		}
		/**
		 * This hook is used to alert the pagination number.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_pagination_number', $page_no, $start, $page_count, $current_page);
	}

}

if (!function_exists('wal_dashboard_guest_login_notice')) {

	/**
	 * Get the message for guest login notice.
	 *
	 *  @return string
	 */
	function wal_dashboard_guest_login_notice() {

		$messgae = get_option('wal_messages_shortcode_guest_login');
		$login_url = '<a href="' . esc_url(wc_get_page_permalink('myaccount')) . '">' . esc_html(get_option('wal_messages_shortcode_guest_login_label')) . '</a>';
		$messgae = str_replace('{login}', $login_url, $messgae);
		/**
		 * This hook is used to alert the dashboard guest login notice.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_dashboard_guest_login_notice', $messgae);
	}

}

if (!function_exists('wal_topup_predefined_buttons')) {

	/**
	 * Get the top up predefined buttons.
	 *
	 *  @return array
	 */
	function wal_topup_predefined_buttons() {
		$predefined_buttons = get_option('wal_general_topup_predefined_buttons');
		$predefined_buttons = array_filter(array_unique(explode(',', $predefined_buttons)), 'wal_array_filter');
		/**
		 * This hook is used to alert the top-up predefined buttons.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_topup_predefined_buttons', $predefined_buttons);
	}

}

if (!function_exists('wal_wallet_overview_data')) {

	/**
	 * Get the wallet overview data.
	 *
	 * @return array
	 */
	function wal_wallet_overview_data() {
		$data = array(
			'topup_total' => array(
				'label' => get_option('wal_localization_dashboard_topup_total_label'),
				'value' => wal_convert_price_by_currency(WAL_Current_User_Wallet::get_topup_total()),
			),
			'usage_total' => array(
				'label' => get_option('wal_localization_dashboard_usage_total_label'),
				'value' => wal_convert_price_by_currency(WAL_Current_User_Wallet::get_usage_total()),
			),
			'expired_total' => array(
				'label' => get_option('wal_localization_dashboard_expired_total_label'),
				'value' => wal_convert_price_by_currency(WAL_Current_User_Wallet::get_expired_total()),
			),
		);
		/**
		 * This hook is used to alert the wallet overview data.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_wallet_overview_data', $data);
	}

}

if (!function_exists('wal_get_partial_usage_balance_message')) {

	/**
	 * Get the message for partial usage balance.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_usage_balance_message() {
		$msg = get_option('wal_messages_partial_usage_balance');
		$balance_message = str_replace('{balance}', wal_convert_price_by_currency(WAL_Current_User_Wallet::get_balance()), $msg);
		/**
		 * This hook is used to alert the partial usage balance message.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_usage_balance_message', $balance_message, $msg);
	}

}

if (!function_exists('wal_get_partial_fund_usage_limit_message')) {

	/**
	 * Get the message for partial fund usage limit.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_partial_fund_usage_limit_message() {
		$usage_limit = wal_get_maximum_fund_usage_limit();
		$max_redeem_funds = ( $usage_limit ) ? $usage_limit : WAL_Current_User_Wallet::get_balance();

		$msg = get_option('wal_messages_partial_fund_usage_limit');
		$balance_message = str_replace('{max_redeem_funds}', wal_convert_price_by_currency($max_redeem_funds), $msg);
		/**
		 * This hook is used to alert the partial fund usage limit message.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_partial_fund_usage_limit_message', $balance_message, $msg);
	}

}

if (!function_exists('wal_get_wallet_inactive_admin_message')) {

	/**
	 * Get the message for wallet In-active admin.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_wallet_inactive_admin_message() {
		/**
		 * This hook is used to alert the wallet inactive admin message.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_wallet_inactive_admin_message', get_option('wal_messages_admin_wallet_inactive'));
	}

}

if (!function_exists('wal_topup_bonus_fund_credit_log_label')) {

	/**
	 * Get the label for top-up bonus fund credit log.
	 *
	 * @since 2.5.0
	 * 
	 * @return string.
	 * 
	 * */
	function wal_topup_bonus_fund_credit_log_label() {
		/**
		 * This hook is used to alert the top up bonus credit log label.
		 * 
		 * @since 2.5.0
		 */
		return apply_filters('wal_topup_bonus_fund_credit_log_label', get_option('wal_localization_wallet_topup_bonus_fund_credit_log'));
	}

}

if (!function_exists('wal_topup_bonus_fund_debit_log')) {

	/**
	 * Get the label for top-up bonus fund debit log.
	 *
	 * @since 2.5.0
	 * 
	 * @return string.
	 * 
	 * */
	function wal_topup_bonus_fund_debit_log() {
		/**
		 * This hook is used to alert the top-up bonus debit log label.
		 * 
		 * @since 2.5.0
		 */
		return apply_filters('wal_topup_bonus_fund_debit_log', get_option('wal_localization_wallet_topup_bonus_fund_debit_log'));
	}

}

if (!function_exists('wal_earn_fund_notice')) {

	/**
	 * Get the message for earn fund notice.
	 *
	 * @since 3.3.0
	 * @param float $fund
	 * @return string
	 */
	function wal_earn_fund_notice( $fund ) {
		$message = str_replace('{product_funds}', $fund, get_option('wal_module_earn_fund_message'));
		/**
		 * This hook is used to alert the earn funds notice.
		 * 
		 * @param string $message
		 * @since 3.3.0
		 */
		return apply_filters('wal_earn_fund_notice', $message);
	}

}

if (!function_exists('wal_transaction_logs_pagination_range')) {

	/**
	 * Get the transaction logs pagination range.
	 *
	 * @since 3.4.0
	 * @return string
	 */
	function wal_transaction_logs_pagination_range() {
		/**
		 * This hook is used to alert the transaction log pagination count.
		 * 
		 * @since 3.4.0
		 * @return string
		 */
		return apply_filters('wal_transaction_logs_pagination_range', get_option('wal_general_transaction_logs_pagination_range', 5));
	}

}

if (!function_exists('wal_get_checkout_redeem_wallet_fund_form_html')) {

	/**
	 * Get the wallet checkout redeem fund form.
	 *
	 * @since 4.0.0
	 * @return string
	 */
	function wal_get_checkout_redeem_wallet_fund_form_html() {
		ob_start();
		WAL_Checkout_Handler::render_checkout_redeem_wallet_fund_form();        
		$contents = ob_get_contents();
		ob_end_clean();

		/**
		 * This hook is used to alter the wallet checkout redeem fund form HTML.
		 * 
		 * @since 4.0.0
		 */
		return apply_filters('wal_checkout_redeem_wallet_fund_form_html', $contents);
	}

}

if (!function_exists('wal_get_discount_notice_for_gateway')) {

	/**
	 * Get the discount notice for wallet gateway.
	 *
	 * @since 4.6.0
	 * @return string
	 */
	function wal_get_discount_notice_for_gateway() {
		ob_start();
		WAL_Checkout_Handler::render_discount_notice_for_gateway();        
		$contents = ob_get_contents();
		ob_end_clean();

		/**
		 * This hook is used to alter the notice for wallet gateway.
		 * 
		 * @since 4.6.0
		 */
		return apply_filters('wal_get_discount_notice_for_gateway', $contents);
	}

}
