<?php

/**
 * Module template functions.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!function_exists('wal_get_fund_transfer_menu_endpoint')) {

	/**
	 * Get the endpoint for fund transfer menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_menu_endpoint() {
		/**
		 * This hook is used to alter the fund transfer menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_menu_endpoint', get_option('wal_module_fund_transfer_menu_endpoint'));
	}

}

if (!function_exists('wal_get_fund_request_menu_endpoint')) {

	/**
	 * Get the endpoint for fund request menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_menu_endpoint() {
		/**
		 * This hook is used to alter the fund request menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_menu_endpoint', get_option('wal_module_fund_request_menu_endpoint'));
	}

}

if (!function_exists('wal_get_fund_transfer_transaction_menu_endpoint')) {

	/**
	 * Get the endpoint for fund transfer transaction menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_transaction_menu_endpoint() {
		/**
		 * This hook is used to alter the fund transfer transaction menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_transaction_menu_endpoint', get_option('wal_module_fund_transfer_transaction_menu_endpoint'));
	}

}


if (!function_exists('wal_get_fund_transfer_details_menu_endpoint')) {

	/**
	 * Get the endpoint for fund transfer details menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_details_menu_endpoint() {
		/**
		 * This hook is used to alter the fund transfer details menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_details_menu_endpoint', get_option('wal_module_fund_transfer_details_menu_endpoint'));
	}

}

if (!function_exists('wal_get_fund_transfer_menu_label')) {

	/**
	 * Get the label for fund transfer menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_menu_label() {
		/**
		 * This hook is used to alter the fund transfer menu label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_menu_label', get_option('wal_module_fund_tansfer_menu_label'));
	}

}

if (!function_exists('wal_get_fund_request_menu_label')) {

	/**
	 * Get the label for fund request menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_menu_label() {
		/**
		 * This hook is used to alter the fund request menu label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_menu_label', get_option('wal_module_fund_request_menu_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_transaction_menu_label')) {

	/**
	 * Get the label for fund transfer transaction menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_transaction_menu_label() {
		/**
		 * This hook is used to alter the fund transfer transaction menu label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_transaction_menu_label', get_option('wal_module_fund_tansfer_transaction_menu_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_details_menu_label')) {

	/**
	 * Get the label for fund transfer details menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_details_menu_label() {
		/**
		 * This hook is used to alter the fund transfer details menu label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_details_menu_label', get_option('wal_module_fund_tansfer_details_menu_label'));
	}

}

if (!function_exists('wal_get_fund_received_total_label')) {

	/**
	 * Get the label for fund received total.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_received_total_label() {
		/**
		 * This hook is used to alter the fund received total label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_received_total_label', get_option('wal_module_received_total_label'));
	}

}

if (!function_exists('wal_get_fund_transferred_total_label')) {

	/**
	 * Get the label for fund transferred total.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transferred_total_label() {
		/**
		 * This hook is used to alter the fund transferred total label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transferred_total_label', get_option('wal_module_transferred_total_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_user_selection_label')) {

	/**
	 * Get the label for fund transfer user selection.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_user_selection_label() {
		/**
		 * This hook is used to alter the fund transfer user selection label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_user_selection_label', get_option('wal_module_fund_transfer_user_selection_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_user_selection_placeholder_label')) {

	/**
	 * Get the label for fund transfer user selection placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_user_selection_placeholder_label() {
		/**
		 * This hook is used to alter the fund transfer user selection placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_user_selection_placeholder_label', get_option('wal_module_fund_transfer_user_selection_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_user_name_label')) {

	/**
	 * Get the label for fund transfer user name.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_user_name_label() {
		/**
		 * This hook is used to alter the fund transfer user name label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_user_name_label', get_option('wal_module_fund_transfer_user_name_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_user_balance_label')) {

	/**
	 * Get the label for fund transfer user balance.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_user_balance_label() {
		/**
		 * This hook is used to alter the fund transfer user balance label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_user_balance_label', get_option('wal_module_fund_transfer_user_balance_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_amount_label')) {

	/**
	 * Get the label for fund transfer amount.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_amount_label() {
		/**
		 * This hook is used to alter the fund transfer amount label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_amount_label', get_option('wal_module_fund_transfer_amount_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_amount_placeholder_label')) {

	/**
	 * Get the label for fund transfer amount placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_amount_placeholder_label() {
		/**
		 * This hook is used to alter the fund transfer amount placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_amount_placeholder_label', get_option('wal_module_fund_transfer_amount_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_fee_label')) {

	/**
	 * Get the label for fund transfer fee.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_fee_label() {
		/**
		 * This hook is used to alter the fund transfer fee label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_fee_label', get_option('wal_module_fund_transfer_fee_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_reason_label')) {

	/**
	 * Get the label for fund transfer reason.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_reason_label() {
		/**
		 * This hook is used to alter the fund transfer reason label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_reason_label', get_option('wal_module_fund_transfer_reason_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_reason_placeholder_label')) {

	/**
	 * Get the label for fund transfer reason placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_reason_placeholder_label() {
		/**
		 * This hook is used to alter the fund transfer placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_reason_placeholder_label', get_option('wal_module_fund_transfer_reason_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_otp_label')) {

	/**
	 * Get the label for fund transfer OTP.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_otp_label() {
		/**
		 * This hook is used to alter the fund transfer OTP label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_otp_label', get_option('wal_module_fund_transfer_otp_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_button_label')) {

	/**
	 * Get the label for fund transfer button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_button_label() {
		/**
		 * This hook is used to alter the fund transfer button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_button_label', get_option('wal_module_fund_transfer_button_label'));
	}

}

if (!function_exists('wal_get_fund_transfer_confirm_button_label')) {

	/**
	 * Get the label for fund transfer confirm button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_transfer_confirm_button_label() {
		/**
		 * This hook is used to alter the fund transfer confirm button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_confirm_button_label', get_option('wal_module_fund_transfer_confirm_button_label'));
	}

}

if (!function_exists('wal_get_fund_request_user_selection_label')) {

	/**
	 * Get the label for fund request user selection.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_user_selection_label() {
		/**
		 * This hook is used to alter the fund request user selection label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_user_selection_label', get_option('wal_module_fund_request_user_selection_label'));
	}

}

if (!function_exists('wal_get_fund_request_user_selection_placeholder_label')) {

	/**
	 * Get the label for fund request user selection placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_user_selection_placeholder_label() {
		/**
		 * This hook is used to alter the fund request user selection placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_user_selection_placeholder_label', get_option('wal_module_fund_request_user_selection_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_request_user_name_label')) {

	/**
	 * Get the label for fund request user name.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_user_name_label() {
		/**
		 * This hook is used to alter the fund request user name label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_user_name_label', get_option('wal_module_fund_request_user_name_label'));
	}

}

if (!function_exists('wal_get_fund_request_user_balance_label')) {

	/**
	 * Get the label for fund request user balance.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_user_balance_label() {
		/**
		 * This hook is used to alter the fund request user balance label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_user_balance_label', get_option('wal_module_fund_request_user_balance_label'));
	}

}

if (!function_exists('wal_get_fund_request_amount_label')) {

	/**
	 * Get the label for fund request amount.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_amount_label() {
		/**
		 * This hook is used to alter the fund request amount label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_amount_label', get_option('wal_module_fund_request_amount_label'));
	}

}

if (!function_exists('wal_get_fund_request_amount_placeholder_label')) {

	/**
	 * Get the label for fund request amount placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_amount_placeholder_label() {
		/**
		 * This hook is used to alter the fund request amount placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_amount_placeholder_label', get_option('wal_module_fund_request_amount_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_request_reason_label')) {

	/**
	 * Get the label for fund request reason.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_reason_label() {
		/**
		 * This hook is used to alter the fund request reason label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_reason_label', get_option('wal_module_fund_request_reason_label'));
	}

}

if (!function_exists('wal_get_fund_request_reason_placeholder_label')) {

	/**
	 * Get the label for fund request reason placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_reason_placeholder_label() {
		/**
		 * This hook is used to alter the fund request reason placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_reason_placeholder_label', get_option('wal_module_fund_request_reason_placeholder_label'));
	}

}

if (!function_exists('wal_get_fund_request_button_label')) {

	/**
	 * Get the label for fund request button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_fund_request_button_label() {
		/**
		 * This hook is used to alter the fund request button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_request_button_label', get_option('wal_module_fund_request_button_label'));
	}

}

if (!function_exists('wal_fund_transfer_transaction_columns')) {

	/**
	 * Get the fund transfer transaction columns.
	 *
	 *  @return array
	 */
	function wal_fund_transfer_transaction_columns() {
		/**
		 * This hook is used to alter the fund transaction columns.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfer_transaction_columns', array(
			'user_name' => get_option('wal_module_transaction_username_label'),
			'transfered_total' => get_option('wal_module_transaction_transfered_total_label'),
			'received_total' => get_option('wal_module_transaction_received_total_label'),
			'last_activity_date' => get_option('wal_module_transaction_last_activity_date_label'),
			'status' => get_option('wal_module_transaction_status_label'),
			'actions' => get_option('wal_module_transaction_actions_label'),
		));
	}

}

if (!function_exists('wal_fund_transfers_pagination_count')) {

	/**
	 * Get the fund transfers pagination count.
	 *
	 *  @return string
	 */
	function wal_fund_transfers_pagination_count() {
		/**
		 * This hook is used to alter the fund transfer pagination count.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_fund_transfers_pagination_count', get_option('wal_module_fund_transfer_transactions_pagination_count', 5));
	}

}

if (!function_exists('wal_format_fund_transfer_log_status')) {

	/**
	 * Format the fund transfer log status.
	 *
	 *  @return bool
	 */
	function wal_format_fund_transfer_log_status( &$transaction_log ) {
		$status = '';
		if (!is_object($transaction_log)) {
			return $status;
		}

		if (!$transaction_log->exists()) {
			return $status;
		}

		switch ($transaction_log->get_status()) {
			case 'wal_transfered':
				/* translators: %1s- date */
				$status = sprintf(__('Transferred on %s', 'wallet-for-woocommerce'), $transaction_log->get_formatted_created_date());
				break;

			case 'wal_received':
				/* translators: %1s- date */
				$status = sprintf(__('Received on %s', 'wallet-for-woocommerce'), $transaction_log->get_formatted_created_date());
				break;

			case 'wal_requested':
				/* translators: %1s- date */
				$status = sprintf(__('Request Sent on %s', 'wallet-for-woocommerce'), $transaction_log->get_formatted_created_date());
				break;

			case 'wal_request_received':
				/* translators: %1s- date */
				$status = sprintf(__('New Request on %s', 'wallet-for-woocommerce'), $transaction_log->get_formatted_created_date());
				break;

			case 'wal_request_declined':
				/* translators: %1s- amount, %2s - date */
				$status = sprintf(__('Request for %1$s was declined on %2$s', 'wallet-for-woocommerce'), wal_convert_price_by_currency($transaction_log->get_amount()), $transaction_log->get_formatted_created_date());
				break;

			case 'wal_request_cancel':
			default:
				/* translators: %1s- amount, %2s - date */
				$status = sprintf(__('Request for %1$s was cancelled on %2$s', 'wallet-for-woocommerce'), wal_convert_price_by_currency($transaction_log->get_amount()), $transaction_log->get_formatted_created_date());
				break;
		}
		/**
		 * This hook is used to alter the fund transfer log status.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_format_fund_transfer_log_status', $status, $transaction_log);
	}

}

if (!function_exists('wal_get_gift_voucher_menu_endpoint')) {

	/**
	 * Get the endpoint for gift voucher menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_gift_voucher_menu_endpoint() {
		/**
		 * This hook is used to alter the gift voucher menu endpoint.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_gift_voucher_menu_endpoint', get_option('wal_module_gift_voucher_menu_endpoint'));
	}

}

if (!function_exists('wal_get_gift_voucher_menu_label')) {

	/**
	 * Get the label for gift voucher menu.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_gift_voucher_menu_label() {
		/**
		 * This hook is used to alter the gift voucher menu label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_gift_voucher_menu_label', get_option('wal_module_gift_voucher_menu_label'));
	}

}

if (!function_exists('wal_get_gift_voucher_title_label')) {

	/**
	 * Get the label for gift voucher title.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_gift_voucher_title_label() {
		/**
		 * This hook is used to alter the gift voucher title label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_gift_voucher_title_label', get_option('wal_module_gift_voucher_field_label'));
	}

}

if (!function_exists('wal_get_gift_voucher_placeholder_label')) {

	/**
	 * Get the label for  gift voucher placeholder.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_gift_voucher_placeholder_label() {
		/**
		 * This hook is used to alter the gift voucher placeholder label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_gift_voucher_placeholder_label', get_option('wal_module_gift_voucher_field_placeholder_label'));
	}

}

if (!function_exists('wal_get_gift_voucher_button_label')) {

	/**
	 * Get the label for gift voucher button.
	 * 
	 * @return string.
	 * 
	 * */
	function wal_get_gift_voucher_button_label() {
		/**
		 * This hook is used to alter the gift voucher button label.
		 * 
		 * @since 1.0
		 */
		return apply_filters('wal_gift_voucher_button_label', get_option('wal_module_gift_voucher_redeem_button_label'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_details_menu_endpoint')) {

	/**
	 * Get the endpoint for wallet withdrawal details menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_details_menu_endpoint() {
		/**
		 * This hook is used to alter the wallet withdrawal details menu endpoint.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_details_menu_endpoint', get_option('wal_module_wallet_withdrawal_details_menu_endpoint'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_transaction_menu_endpoint')) {

	/**
	 * Get the endpoint for wallet withdrawal details menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_transaction_menu_endpoint() {
		/**
		 * This hook is used to alter the wallet withdrawal transaction menu endpoint.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_transaction_menu_endpoint', get_option('wal_module_wallet_withdrawal_transaction_menu_endpoint'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_request_menu_endpoint')) {

	/**
	 * Get the endpoint for wallet withdrawal request menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_request_menu_endpoint() {
		/**
		 * This hook is used to alter the wallet withdrawal request menu endpoint.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_request_menu_endpoint', get_option('wal_module_wallet_withdrawal_request_menu_endpoint'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_details_menu_label')) {

	/**
	 * Get the label for wallet withdrawal details menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_details_menu_label() {
		/**
		 * This hook is used to alter the wallet withdrawal details menu label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_details_menu_label', get_option('wal_module_wallet_withdrawal_details_menu_label'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_transaction_menu_label')) {

	/**
	 * Get the label for wallet withdrawal transaction menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_transaction_menu_label() {
		/**
		 * This hook is used to alter the wallet withdrawal transaction menu label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_transaction_menu_label', get_option('wal_module_wallet_withdrawal_transaction_menu_label'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_request_menu_label')) {

	/**
	 * Get the label for wallet withdrawal request menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_request_menu_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request menu label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_request_menu_label', get_option('wal_module_wallet_withdrawal_request_menu_label'));
	}

}

if (!function_exists('wal_get_wallet_withdrawal_settings_menu_label')) {

	/**
	 * Get the label for wallet withdrawal settings menu.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_wallet_withdrawal_settings_menu_label() {
		/**
		 * This hook is used to alter the wallet withdrawal settings menu label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_wallet_withdrawal_settings_menu_label', get_option('wal_module_wallet_withdrawal_settings_menu_label'));
	}

}

if (!function_exists('wal_get_withdrawal_settings_button_label')) {

	/**
	 * Get the label for wallet withdrawal settings button.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_settings_button_label() {
		/**
		 * This hook is used to alter the wallet withdrawal settings button label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_settings_button_label', get_option('wal_module_wallet_withdrawal_save_settings_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_account_number_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway account number.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_account_number_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway account number label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_account_number_label', get_option('wal_module_withdrawal_bank_account_number_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_account_name_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway account name.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_account_name_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway account name label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_account_name_label', get_option('wal_module_withdrawal_bank_account_name_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_ifsc_code_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway IFSC code.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_ifsc_code_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway IFSC code label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_ifsc_code_label', get_option('wal_module_withdrawal_bank_ifsc_code_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_bank_name_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway bank name.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_bank_name_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway bank name label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_bank_name_label', get_option('wal_module_withdrawal_bank_bank_name_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_routing_number_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway routing number.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_routing_number_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway routing number label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_routing_number_label', get_option('wal_module_withdrawal_bank_routing_number_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_iban_number_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway IBAN number.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_iban_number_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway IBAN number label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_iban_number_label', get_option('wal_module_withdrawal_bank_iban_number_label'));
	}

}

if (!function_exists('wal_get_withdrawal_bank_gateway_swift_code_label')) {

	/**
	 * Get the label for wallet withdrawal bank gateway swift code.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_bank_gateway_swift_code_label() {
		/**
		 * This hook is used to alter the wallet withdrawal bank gateway swift code label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_bank_gateway_swift_code_label', get_option('wal_module_withdrawal_bank_swift_code_label'));
	}

}

if (!function_exists('wal_get_withdrawal_paypal_gateway_email_label')) {

	/**
	 * Get the label for wallet withdrawal paypal gateway email.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_paypal_gateway_email_label() {
		/**
		 * This hook is used to alter the wallet withdrawal paypal gateway email label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_paypal_gateway_email_label', get_option('wal_module_withdrawal_paypal_email_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_user_balance_label')) {

	/**
	 * Get the label for wallet withdrawal request user balance.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_user_balance_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request user balance label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_user_balance_label', get_option('wal_module_wallet_withdrawal_request_balance_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_amount_label')) {

	/**
	 * Get the label for wallet withdrawal request amount.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_amount_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request amount label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_amount_label', get_option('wal_module_wallet_withdrawal_request_amount_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_amount_placeholder_label')) {

	/**
	 * Get the label for wallet withdrawal request amount placeholder.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_amount_placeholder_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request amount placeholder label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_amount_placeholder_label', get_option('wal_module_wallet_withdrawal_request_amount_placeholder_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_fee_label')) {

	/**
	 * Get the label for wallet withdrawal request fee.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_fee_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request fee label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_fee_label', get_option('wal_module_wallet_withdrawal_request_fee_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_payment_gateway_selection_label')) {

	/**
	 * Get the label for wallet withdrawal request payment gateway selection.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_payment_gateway_selection_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request payment gateway selection label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_payment_gateway_selection_label', get_option('wal_module_wallet_withdrawal_request_payment_method_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_payment_gateway_option_label')) {

	/**
	 * Get the label for wallet withdrawal request payment gateway option.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_payment_gateway_option_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request payment gateway option label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_payment_gateway_option_label', get_option('wal_module_wallet_withdrawal_request_payment_method_option_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_button_label')) {

	/**
	 * Get the label for wallet withdrawal request button.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_button_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request button label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_button_label', get_option('wal_module_wallet_withdrawal_request_button_label'));
	}

}


if (!function_exists('wal_get_withdrawal_request_otp_label')) {

	/**
	 * Get the label for wallet withdrawal request verify OTP.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_otp_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request verify OTP label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_otp_label', get_option('wal_module_wallet_withdrawal_request_otp_label'));
	}

}

if (!function_exists('wal_get_withdrawal_request_confirm_button_label')) {

	/**
	 * Get the label for wallet withdrawal request verify OTP.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_withdrawal_request_confirm_button_label() {
		/**
		 * This hook is used to alter the wallet withdrawal request confirm button label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_withdrawal_request_confirm_button_label', get_option('wal_module_wallet_withdrawal_request_confirm_button_label'));
	}

}

if (!function_exists('wal_wallet_withdrawal_transactions_columns')) {

	/**
	 * Get the wallet withdrawal transactions columns.
	 *
	 * @since 1.8
	 * @return array
	 */
	function wal_wallet_withdrawal_transactions_columns() {
		/**
		 * This hook is used to alter the wallet withdrawal transactions columns.
		 * 
		 * @since 1.8
		 * @param array
		 */
		return apply_filters('wal_wallet_withdrawal_transactions_columns', array(
			'amount' => get_option('wal_module_wallet_withdrawal_transaction_amount_label'),
			'fee' => get_option('wal_module_wallet_withdrawal_transaction_fee_label'),
			'payment_method' => get_option('wal_module_wallet_withdrawal_transaction_payment_method_label'),
			'status' => get_option('wal_module_wallet_withdrawal_transaction_status_label'),
			'created_date' => get_option('wal_module_wallet_withdrawal_transaction_created_date_label'),
				)
		);
	}

}

if (!function_exists('wal_get_fund_withdrew_total_label')) {

	/**
	 * Get the label for fund withdrew total.
	 * 
	 * @since 1.8
	 * @return string.
	 * */
	function wal_get_fund_withdrew_total_label() {
		/**
		 * This hook is used to alter the fund withdrew total label.
		 * 
		 * @since 1.8
		 * @param string
		 */
		return apply_filters('wal_fund_withdrew_total_label', get_option('wal_module_wallet_withdrawal_withdrew_total_label'));
	}

}

if (!function_exists('wal_prepare_product_awarding_fund_message')) {

	/**
	 * Prepare product awarding fund message.
	 *
	 * @param int $id
	 * @param float fund
	 * @since 3.1.0
	 * 
	 * @return string.
	 * */
	function wal_prepare_product_awarding_fund_message( $id, $fund ) {
		$find = array( '{product_name}', '{product_purchase_funds}' );
		$replace = array( '<b>' . wc_get_product($id)->get_name() . '</b>', wal_convert_price_by_currency($fund) );
		$message = str_replace($find, $replace, get_option('wal_module_product_purchase_fund_message'));

		/**
		 * This hook is used to alter the wallet prepare product awarding fund message.
		 *
		 * @param string $message
		 * @since 3.1.0
		 */
		return apply_filters('wal_prepare_product_awarding_fund_message', $message);
	}

}

if (!function_exists('wal_prepare_order_awarding_fund_message')) {

	/**
	 * Prepare order awarding fund message.
	 *
	 * @param float fund
	 * @since 3.1.0
	 * 
	 * @return string.
	 * */
	function wal_prepare_order_awarding_fund_message( $fund ) {
		$message = str_replace('{order_funds}', wal_convert_price_by_currency($fund), get_option('wal_module_product_purchase_order_fund_message'));

		/**
		 * This hook is used to alter the wallet prepare order awarding fund message.
		 *
		 * @param string $message
		 * @since 3.1.0
		 */
		return apply_filters('wal_prepare_order_awarding_fund_message', $message);
	}

}

if (!function_exists('wal_prepare_category_awarding_fund_message')) {

	/**
	 * Prepare category awarding fund message.
	 *
	 * @param float fund
	 * @since 5.1.0
	 * 
	 * @return string.
	 * */
	function wal_prepare_category_awarding_fund_message( $fund, $category_names ) {
		$category_names = wal_check_is_array($category_names) ? implode(',', $category_names) : '';
		$message = str_replace( array( '{category_funds_value}', '{category_name}' ), array( wal_convert_price_by_currency($fund), $category_names ), get_option('wal_module_category_total_range_message_in_cart_and_checkout'));

		/**
		 * This hook is used to alter the wallet prepare order awarding fund message.
		 *
		 * @param string $message
		 * @since 5.1.0
		 */
		return apply_filters('wal_prepare_category_awarding_fund_message', $message);
	}

}

if (!function_exists('wal_valid_shipping_method_lists_message')) {

	/**
	 * Valid shipping method lists message.
	 *
	 * @since 4.3.0
	 * 
	 * @return string.
	 * */
	function wal_valid_shipping_method_lists_message() {
		$link = '<a href="#" class="wal-shipping-list-options" data-shipping_lists="' . implode(' , ', wal_get_shipping_methods()) . '" >' . __('Shipping Methods', 'wallet-for-woocommerce') . '</a>' ;
		?>
		<div class='wal-hide wal-popup' data-popup='#wal-shipping-lists-modal'>
			<div id='wal-shipping-lists-modal'></div>
		</div>
		<?php
		$message = str_replace('{shipping method(s)}', $link, get_option('wal_module_product_purchase_valid_shipping_method_message'));

		/**
		 * This hook is used to alter the wallet valid shipping method lists message.
		 *
		 * @param string $message
		 * @since 4.3.0
		 */
		return apply_filters('wal_valid_shipping_method_lists_message', $message);
	}

}

if (!function_exists('wal_prepare_purchased_product_event_message')) {

	/**
	 * Prepare purchased product event message
	 *
	 * @param object $order
	 * @param int $product_id
	 * @param string $message
	 * 
	 * @since 3.1.0
	 * @return string
	 */
	function wal_prepare_purchased_product_event_message( $order, $product_id, $message ) {
		$product = wc_get_product($product_id);
		if (!is_object($product)) {
			return '';
		}

		$find = array( '{product_name}', '{order_id}' );
		$replace = array( $product->get_name(), '#' . $order->get_id() );
		$event_message = str_replace($find, $replace, $message);

		/**
		 * This hook is used to alert the purchased product event message.
		 *
		 * @param string $event_message
		 * @since 3.1.0
		 */
		return apply_filters('wal_prepare_purchased_product_event_message', $event_message);
	}

}

if (!function_exists('wal_prepare_purchased_order_event_message')) {

	/**
	 * Prepare purchased order event message
	 *
	 * @param object $order        
	 * @param string $message
	 * 
	 * @since 3.1.0
	 * @return string
	 */
	function wal_prepare_purchased_order_event_message( $order, $message ) {
		$event_message = str_replace('{order_id}', '#' . $order->get_id(), $message);
		/**
		 * This hook is used to alert the purchased order event message.
		 *
		 * @param string $event_message
		 * @since 3.1.0
		 */
		return apply_filters('wal_prepare_purchased_order_event_message', $event_message);
	}

}

if (!function_exists('wal_get_shipping_method_lists_label')) {
	
	/**
	 * Get a shipping method lists label.
	 *
	 * @since 4.3.0
	 * @return string
	 */
	function wal_get_shipping_method_lists_label() {
		/**
		* This hook is used to alter the shipping methods list label.
		*
		* @since 4.3.0
		*/
		return apply_filters( 'wal_shipping_method_lists_label', get_option('wal_module_product_purchase_shipping_method_lists_label') );
	}
}
