<?php
/*
 * GDPR Compliance
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly
}

if ( ! class_exists( 'WAL_Privacy' ) ) :

	/**
	 * Class.
	 */
	class WAL_Privacy {

		/**
		 * Constructor.
		 */
		public function __construct() {
			$this->init_hooks() ;
		}

		/**
		 * Register plugin
		 */
		public function init_hooks() {
			// This hook register plugin privacy content.
			add_action( 'admin_init' , array( __CLASS__, 'register_privacy_content' ) , 20 ) ;
		}

		/**
		 * Register the privacy content.
		 */
		public static function register_privacy_content() {
			if ( ! function_exists( 'wp_add_privacy_policy_content' ) ) {
				return ;
			}

			$content = self::get_privacy_message() ;
			if ( $content ) {
				wp_add_privacy_policy_content( __( 'Wallet for WooCommerce' , 'wallet-for-woocommerce' ) , $content ) ;
			}
		}

		/**
		 * Prepare the privacy content.
		 * 
		 * @return html
		 */
		public static function get_privacy_message() {

			return self::get_privacy_message_html() ;
		}

		/**
		 * Get thr privacy content.
		 * 
		 * @return html
		 */
		public static function get_privacy_message_html() {
			ob_start() ;
			?>
			<p><?php esc_html_e( 'This includes the basics of what personal data your store may be collecting, storing and sharing. Depending on what settings are enabled and which additional plugins are used, the specific information shared by your store will vary.' , 'wallet-for-woocommerce' ) ; ?></p>
			<h2><?php esc_html_e( 'WHAT DOES THE PLUGIN DO?' , 'wallet-for-woocommerce' ) ; ?></h2>
			<p><?php esc_html_e( ' Wallet for WooCommerce helps your users to quickly complete a purchase by adding funds to the site and using them for future purchases.' , 'wallet-for-woocommerce' ) ; ?> </p>
			<h2><?php esc_html_e( 'WHAT WE COLLECT AND STORE?' , 'wallet-for-woocommerce' ) ; ?></h2>
			<h3><?php esc_html_e( 'Username and Email' , 'wallet-for-woocommerce' ) ; ?></h3>
			<p><?php esc_html_e( 'To identify the user who adds funds to the account.' , 'wallet-for-woocommerce' ) ; ?></p>
			<?php
			$contents = ob_get_contents() ;
			ob_end_clean() ;

			return $contents ;
		}
	}

	new WAL_Privacy() ;

endif;
