<?php

/**
 * Notifications Instances Class.
 * */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('WAL_Notification_Instances')) {

	/**
	 * Class.
	 * */
	class WAL_Notification_Instances {

		/**
		 * Notifications.
		 * 
		 * @var array
		 * */
		private static $notifications = array();

		/**
		 * Get the all notifications.
		 * 
		 * @return array
		 * */
		public static function get_notifications() {
			if (!self::$notifications) {
				self::load_notifications();
			}

			return self::$notifications;
		}

		/**
		 * Load all Notifications.
		 * */
		public static function load_notifications() {
			if (!class_exists('WAL_Notifications')) {
				include WAL_PLUGIN_PATH . '/inc/abstracts/abstract-wal-notifications.php';
			}

			/**
			 * This hook is used to alter the wallet email classes.
			 * 
			 * @since 1.0
			 */
			$default_notification_classes = apply_filters('wal_wallet_email_classes', array(
				'admin-wallet-funds-credit' => 'WAL_Admin_Wallet_Funds_Credit_Notification',
				'admin-wallet-funds-debit' => 'WAL_Admin_Wallet_Funds_Debit_Notification',
				'admin-wallet-expired' => 'WAL_Admin_Wallet_Expired_Notification',
				'customer-wallet-funds-topup' => 'WAL_Customer_Wallet_Funds_Topup_Notification',
				'customer-wallet-funds-partial-usage' => 'WAL_Customer_Wallet_Funds_Partial_Usage_Notification',
				'customer-wallet-funds-gateway-usage' => 'WAL_Customer_Wallet_Funds_Gateway_Usage_Notification',
				'customer-wallet-funds-credit' => 'WAL_Customer_Wallet_Funds_Credit_Notification',
				'customer-wallet-funds-debit' => 'WAL_Customer_Wallet_Funds_Debit_Notification',
				'customer-wallet-funds-credit-manually' => 'WAL_Customer_Wallet_Funds_Credit_Manually_Notification',
				'customer-wallet-funds-debit-manually' => 'WAL_Customer_Wallet_Funds_Debit_Manually_Notification',
				'customer-low-wallet-reminder' => 'WAL_Customer_Low_Wallet_Reminder_Notification',
				'customer-wallet-expiry-reminder' => 'WAL_Customer_Wallet_Expiry_Reminder_Notification',
				'customer-wallet-expired' => 'WAL_Customer_Wallet_Expired_Notification',
			));

			foreach ($default_notification_classes as $file_name => $notification_class) {

				// Include notification file.
				include 'class-' . $file_name . '.php';

				// Add notification Object.
				self::add_notification(new $notification_class());
			}
		}

		/**
		 * Add a notification.
		 * 
		 * */
		public static function add_notification( $notification ) {
			self::$notifications[$notification->get_id()] = $notification;
		}

		/**
		 * Get the notification by id.
		 * 
		 * @return object/bool
		 * */
		public static function get_notification_by_id( $notification_id ) {
			$notifications = self::get_notifications();

			return isset($notifications[$notification_id]) ? $notifications[$notification_id] : false;
		}

		/**
		 * Reset.
		 * */
		public static function reset() {
			self::$notifications = null;
		}
	}

}
