<?php

/**
 * Customer - Wallet Auto Topup Cancelled
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Customer_Auto_Topup_Cancelled_Notification' ) ) {

	/**
	 * Class WAL_Customer_Auto_Topup_Cancelled_Notification
	 */
	class WAL_Customer_Auto_Topup_Cancelled_Notification extends WAL_Notifications {

		/**
		 * Class Constructor
		 */
		public function __construct() {

			$this->id          = 'customer_auto_topup_cancelled' ;
			$this->type        = 'customer' ;
			$this->title       = __( 'Customer - Wallet Auto Top-up Cancelled' , 'wallet-for-woocommerce' ) ;
			$this->description = __( 'This email will be sent to the user when auto top-up is cancelled.' , 'wallet-for-woocommerce' ) ;

			// Triggers for this email.
			add_action( sanitize_key( $this->plugin_slug . '_wallet_auto_topup_authorization_is_cancelled' ) , array( $this, 'trigger' ) , 10 , 1 ) ;

			parent::__construct() ;
		}

		/*
		 * Default Subject
		 */

		public function get_default_subject() {

			return '{site_name} - Wallet Auto Top-up Cancelled' ;
		}

		/*
		 * Default Message
		 */

		public function get_default_message() {
			return 'Hi {user_name},

Wallet Auto Top-up on {sitename} is Cancelled due to the following reason.

Reason: {cancellation_reason}

Your current Wallet balance is {wallet_balance}.

Note: 

You can re-authorize your Auto Top-up authorization any time from your Wallet Dashboard.

Thanks.' ;
		}

		/**
		 * Trigger the sending of this email.
		 */
		public function trigger( $auto_topup_id ) {
			if ( ! $this->is_enabled() ) {
				return ;
			}

			$auto_topup = wal_get_auto_topup( $auto_topup_id ) ;

			if ( ! $auto_topup ) {
				return ;
			}

			$this->recipient                               = $auto_topup->get_user()->user_email ;
			$this->placeholders[ '{wallet_balance}' ]      = wal_price( $auto_topup->get_wallet()->get_balance() , array( 'currency', $auto_topup->get_currency() ) ) ;
			$this->placeholders[ '{cancellation_reason}' ] = $auto_topup->get_last_activity() ;
			$this->placeholders[ '{user_name}' ]           = $auto_topup->get_user()->display_name ;

			if ( $this->get_recipient() ) {
				$this->send_email( $this->get_recipient() , $this->get_subject() , $this->get_formatted_message() ) ;
			}
		}

		/**
		 * Get the settings array.
		 * 
		 * @return array
		 * */
		public function get_settings_array() {
			$section_fields = array() ;

			//Email section start.
			$section_fields[] = array(
				'type'  => 'title',
				'title' => __( 'Wallet Auto Top-up Cancelled' , 'wallet-for-woocommerce' ),
				'id'    => 'wal_wallet_auto_topup_cancelled_email_options',
					) ;
			$section_fields[] = array(
				'title'   => __( 'Enable' , 'wallet-for-woocommerce' ),
				'type'    => 'checkbox',
				'default' => 'no',
				'id'      => $this->get_option_key( 'enabled' ),
					) ;
			$section_fields[] = array(
				'title'   => __( 'Subject' , 'wallet-for-woocommerce' ),
				'type'    => 'text',
				'default' => $this->get_default_subject(),
				'id'      => $this->get_option_key( 'subject' ),
					) ;
			$section_fields[] = array(
				'title'     => __( 'Message' , 'wallet-for-woocommerce' ),
				'type'      => 'wal_custom_fields',
				'wal_field' => 'wpeditor',
				'default'   => $this->get_default_message(),
				'id'        => $this->get_option_key( 'message' ),
					) ;
			$section_fields[] = array(
				'type' => 'sectionend',
				'id'   => 'wal_wallet_auto_topup_cancelled_email_options',
					) ;
			//Email section end.

			return $section_fields ;
		}
	}

}
