<?php
/**
 * Wallet withdrawal payment gateways table.
 * 
 * @since 1.8
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<tr valign="top">
	<td class="wal-withdrawal-payment-gateways-wrapper">
		<table class="wal-withdrawal-payment-gateways-table widefat striped">
			<thead>
				<tr>
					<?php
					/**
					 * This hook is used to alter the wallet withdrawal payment gateways columns.
					 * 
					 * @since 1.8
					 * 
					 * @param array
					 */
					$columns = apply_filters( 'wal_wallet_withdrawal_payment_gateways_cloumns', array(
					'status'      => __( 'Status', 'wallet-for-woocommerce' ),
						'name'        => __( 'Name', 'wallet-for-woocommerce' ),
						'description' => __( 'Description', 'wallet-for-woocommerce' ),
						'actions'     => __( 'Actions', 'wallet-for-woocommerce' ),
							) ) ;

					foreach ( $columns as $column_name ) :
						echo '<th>' . esc_html( $column_name ) . '</th>' ;
					endforeach ;
					?>
				</tr>
			</thead>
			<tbody>
				<?php
				$gateways = WAL_Module_Instances::get_module_by_id( 'wallet_withdrawal' )->payment_gateways() ;
				if ( wal_check_is_array( $gateways ) ) :
					foreach ( $gateways as $key => $gateway ) :
						?>
						<tr>
							<?php foreach ( $columns as $cloumn_key => $label ) : ?>
								<?php
								switch ( $cloumn_key ) :
									case 'status':
										?>
										<td data-title="<?php echo esc_attr( $label ) ; ?>">
											<input type="checkbox" name="<?php echo esc_attr( $gateway->get_option_key( 'enabled' ) ) ; ?>" <?php checked( true, $gateway->is_enabled() ) ; ?>/>
										</td>
										<?php
										break ;
									case 'name':
										?>
										<td data-title="<?php echo esc_attr( $label ) ; ?>">
											<a href="<?php echo esc_url( wal_get_module_page_url( array( 'module' => 'wallet_withdrawal', 'tab' => 'payment_method', 'section' => $key ) ) ) ; ?>"><?php echo esc_html( $gateway->get_title() ) ; ?></a>
										</td>
										<?php
										break ;
									case 'description':
										?>
										<td data-title="<?php echo esc_attr( $label ) ; ?>">
											<?php echo esc_html( $gateway->get_description() ) ; ?>
										</td>
										<?php
										break ;
									case 'actions':
										?>
										<td data-title="<?php echo esc_attr( $label ) ; ?>">
											<a href="<?php echo esc_url( wal_get_module_page_url( array( 'module' => 'wallet_withdrawal', 'tab' => 'payment_method', 'section' => $key ) ) ) ; ?>" class="button">
												<?php esc_html_e( 'Manage', 'wallet-for-woocommerce' ) ; ?>
											</a>
										</td>
										<?php
										break ;
									default:
										/**
										 * This hook is used to display the wallet withdrawal gateway custom column content.
										 * 
										 * @since 1.8
										 * 
										 * @param object
										 */
										do_action( 'wal_wallet_withdrawal_payment_gateway_' . $key, $gateway ) ;
										break ;
								endswitch ;
							endforeach ;
							?>
						</tr>
						<?php
					endforeach ;
				endif ;
				?>
			</tbody>
		</table>
	</td>
</tr>
<?php
