<?php
/**
 * Cancelled Reason
 *
 * @since 2.8.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
/**
 * This hook is used to do extra before wallet withdrawal cancelled reason.
 *  
 * @since 2.8.0
 */
do_action('wal_wallet_withdrawal_before_cancelled_reason');
?>
<div class="wal-wallet-withdrawal-cancelled-reason-wrapper">
	<h1>
		<?php
		/* translators: %s - ID */
		echo wp_kses_post(sprintf(__('Withdrawal ID - #%s', 'wallet-for-woocommerce'), absint($withdrawal_id)));
		?>
	</h1>
	<div class="wal-wallet-withdrawal-cancelled-popup-content">
		<h4><b><?php esc_html_e('Cancelled Reason', 'wallet-for-woocommerce'); ?></b></h4>	
		<?php echo wp_kses_post(wpautop($wallet_withdraw->get_cancelled_reason())); ?>
	</div>
</div>
<?php
/**
 * This hook is used to do extra after wallet withdrawal cancelled reason.
 *  
 * @since 2.8.0
 */
do_action('wal_wallet_withdrawal_after_cancelled_reason');
