<?php
/**
 * Product purchase order total range fund.
 * 
 * @since 3.4.0.
 * @var array $product_purchase_range_rules
 * @var array $rules
 * @avr int $fund_type
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>		
<table class='wal-product-purchase-order-total-range-table' >
	<thead>
		<tr>
			<th><?php esc_html_e('Minimum Order Total', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Maximum Order Total', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Fund Type', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Fund Value', 'wallet-for-woocommerce'); ?></th>
			<th colspan="5"><?php esc_html_e('Remove Rule', 'wallet-for-woocommerce'); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (wal_check_is_array($product_purchase_range_rules)) :
			foreach ($product_purchase_range_rules as $key => $rules) :
				$fund_type = isset($rules['fund_type']) ? $rules['fund_type'] : 2;
				?>
				<tr class='wal-product-purchase-range-row' >
					<td><input type='text' class='wal-min-order-total wc_input_price' step ='1' name='wal_module_product_purchase_order_total_range_rules[<?php echo esc_attr($key); ?>][min_order_total]' value='<?php echo esc_attr($rules['min_order_total']); ?>'></td>
					<td><input type='text' class='wal-max-order-total wc_input_price' step ='1' name='wal_module_product_purchase_order_total_range_rules[<?php echo esc_attr($key); ?>][max_order_total]' value='<?php echo esc_attr($rules['max_order_total']); ?>'></td>
					<td>
						<select name='wal_module_product_purchase_order_total_range_rules[<?php echo esc_attr($key); ?>][fund_type]'>
							<option value='2' <?php selected('2', $fund_type); ?>><?php esc_html_e('Percentage of Order Total', 'wallet-for-woocommerce'); ?></option>
							<option value='1' <?php selected('1', $fund_type); ?>><?php esc_html_e('Fixed Amount', 'wallet-for-woocommerce'); ?></option>
						</select>
					</td>
					<td><input type='text' class='wal-fund-value wc_input_price' step ='1' name='wal_module_product_purchase_order_total_range_rules[<?php echo esc_attr($key); ?>][fund_value]' value='<?php echo esc_attr($rules['fund_value']); ?>'></td>
					<td>                        
						<input type='hidden' class='wal-remove-rule-id' value='<?php echo esc_attr($key); ?>' />
						<span class='dashicons dashicons-dismiss wal-remove-rule' title='<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>'></span>
					</td>
				</tr>  
				<?php
			endforeach;
		endif;
		?>
	</tbody>  
	<tfoot>
		<tr>
			<td colspan='5' class='wal-add-new-range-rule'>
				<button type='button' class='wal-add-new-product-purchase-range-rule'>
					<?php esc_html_e('Add New Rule', 'wallet-for-woocommerce'); ?>
				</button>
			</td>
		</tr>
	</tfoot>
</table>  

<script type='text/html' id='tmpl-wal-product-purchase-order-total-range-rules'>
	<tr class='wal-product-purchase-range-row'>
		<td>
			<input type ='text' class='wal-min-order-total' min='0' step ='1' name ='wal_module_product_purchase_order_total_range_rules[{{data.group_id}}][min_order_total]' 
				   min='0' value=''/>
		</td>
		<td>
			<input type ='text' class='wal-max-order-total' min='0' step ='1' name ='wal_module_product_purchase_order_total_range_rules[{{data.group_id}}][max_order_total]' 
				   min='0' value=''/>
		</td>
		<td>
			<select name='wal_module_product_purchase_order_total_range_rules[{{data.group_id}}][fund_type]'>
				<option value='2'><?php esc_html_e('Percentage of Order total', 'wallet-for-woocommerce'); ?></option>  
				<option value='1'><?php esc_html_e('Fixed Amount', 'wallet-for-woocommerce'); ?></option>                                    
			</select>
		</td>
		<td>
			<input type ='text' class='wal-fund-value' min='0' step ='1' name ='wal_module_product_purchase_order_total_range_rules[{{data.group_id}}][fund_value]' 
				   min='0' value=''/>
		</td>
		<td>
			<input type='hidden' class='wal-remove-rule-id' value='[{{data.group_id}}]' />
			<span class='dashicons dashicons-dismiss wal-remove-fund-rule' title='<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>'></span>
		</td>           
	</tr> 
</script>
<?php


