<?php
/**
 * Category total range fund.
 * 
 * @since 5.1.0.
 * @var array $category_total_range_rules
 * @var array $rules
 * @avr int $fund_type
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>		
<table class='wal-category-total-range-table' >
	<thead>
		<tr>
			<th><?php esc_html_e('Category', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Minimum Category Total', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Maximum Category Total', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Fund Value', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Rule Applicable Once per User', 'wallet-for-woocommerce'); ?></th>
			<th colspan="5"><?php esc_html_e('Remove Rule', 'wallet-for-woocommerce'); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (wal_check_is_array($category_total_range_rules)) :
			foreach ($category_total_range_rules as $key => $rules) :
				$included_category = isset($rules['included_category']) ? $rules['included_category'] : array();
				$user_restriction = isset($rules['user_restriction']) ? "checked='checked'" : '';
				$min_category_total = isset($rules['min_category_total']) ? $rules['min_category_total'] : '';
				$max_category_total = isset($rules['max_category_total']) ? $rules['max_category_total'] : '';
				?>
				<tr class='wal-category-total-range-row' >
					<td>
						<select name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][included_category][]' class="wal-category-list wal_select2" multiple="multiple" data-placeholder="<?php echo esc_attr__('Select the Categories', 'wallet-for-woocommerce'); ?>">
							<?php 
							foreach (wal_get_wc_categories() as $category_id => $category_name) : 
								$selected = ( in_array( $category_id, $included_category ) ) ? "selected='selected'" : '';
								?>
								<option value="<?php echo esc_attr($category_id); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html($category_name); ?></option>
							<?php endforeach; ?>
						</select>
					</td>
					<td><input type='text' class='wal-min-category-total wc_input_price' step ='1' name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][min_category_total]' value='<?php echo esc_attr($min_category_total); ?>'></td>
					<td><input type='text' class='wal-max-category-total wc_input_price' step ='1' name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][max_category_total]' value='<?php echo esc_attr($max_category_total); ?>'></td>
					<td><input type='text' class='wal-fund-value wc_input_price' step ='1' name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][fund_value]' value='<?php echo esc_attr($rules['fund_value']); ?>'></td>
					<td><input type='checkbox' class='wal-user-restriction' name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][user_restriction]' <?php echo esc_attr( $user_restriction ); ?>/></td>
					<td>                        
						<input type='hidden' class='wal-remove-rule-id' value='<?php echo esc_attr($key); ?>' />
						<span class='dashicons dashicons-dismiss wal-remove-rule' title='<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>'></span>
					</td>
				</tr>  
				<?php
			endforeach;
		endif;
		?>
	</tbody>  
	<tfoot>
		<tr>
			<td colspan='5' class='wal-add-new-range-rule'>
				<button type='button' class='wal-add-new-category-total-range-rule'>
					<?php esc_html_e('Add New Rule', 'wallet-for-woocommerce'); ?>
				</button>
			</td>
		</tr>
	</tfoot>
</table>  

<script type='text/html' id='tmpl-wal-category-total-range-rules'>
	<tr class='wal-category-total-range-row'>
		<td>
			<select name='wal_module_category_total_range_rules[{{data.group_id}}][included_category][]' class="wal-category-list wal_select2" multiple="multiple" data-placeholder="<?php echo esc_attr__('Select the Categories', 'wallet-for-woocommerce'); ?>">
				<?php foreach (wal_get_wc_categories() as $key => $label) : ?>
					<option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($label); ?></option>
				<?php endforeach; ?>
			</select>
		</td>
		<td>
			<input type ='text' class='wal-min-category-total' min='0' step ='1' name ='wal_module_category_total_range_rules[{{data.group_id}}][min_category_total]' 
				   min='0' value=''/>
		</td>
		<td>
			<input type ='text' class='wal-max-category-total' min='0' step ='1' name ='wal_module_category_total_range_rules[{{data.group_id}}][max_category_total]' 
				   min='0' value=''/>
		</td>
		<td>
			<input type ='text' class='wal-fund-value' min='0' step ='1' name ='wal_module_category_total_range_rules[{{data.group_id}}][fund_value]' 
				   min='0' value=''/>
		</td>
		<td><input type='checkbox' class='wal-user-restriction' name='wal_module_category_total_range_rules[<?php echo esc_attr($key); ?>][user_restriction]' /></td>
		<td>
			<input type='hidden' class='wal-remove-rule-id' value='[{{data.group_id}}]' />
			<span class='dashicons dashicons-dismiss wal-remove-category-range-fund-rule' title='<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>'></span>
		</td>           
	</tr> 
</script>
<?php


