<?php
/**
 * Auto top up renewal order details
 *
 * @since 2.8.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
/**
 * This hook is used to do extra before renewal order details table.
 *  
 * @since 2.8.0
 */
do_action('wal_auto_topup_before_renewal_order_details');
?>
<h3 class="wal-wallet-withdrawal-head">
	<?php
	/* translators: %s - ID */
	echo wp_kses_post(sprintf(__('Authorized Order Number - %s', 'wallet-for-woocommerce'), "<a target='blank' href='" . get_edit_post_link($order_id) . "'>#{$order_id}</a>"));
	?>
</h3>

<table class='wal-renewal-order-detail-table'>    
	<tr class='wal-renewal-order-head'>
		<th><?php esc_html_e('Order ID', 'wallet-for-woocommerce'); ?></th>
		<th><?php esc_html_e('Order Amount', 'wallet-for-woocommerce'); ?></th>		
		<th><?php esc_html_e('Date', 'wallet-for-woocommerce'); ?></th>
	</tr>
	<?php
	foreach ($renewal_order_ids as $renewal_order_id) :
		$renewal_order = wc_get_order($renewal_order_id);
		if (!$renewal_order) :
			continue;
		endif;
		?>
		<tr class='wal-renewal-order-data'>        
			<td><?php echo wp_kses_post(sprintf("<a target='blank' href='%s'>%s</a>", get_edit_post_link($renewal_order_id), '#' . $renewal_order_id)); ?> </td>
			<td><?php echo wp_kses_post($renewal_order->get_total()); ?> </td>			
			<td><?php echo wp_kses_post(WAL_Date_Time::get_mysql_date_time_format($renewal_order->get_date_created()->date('Y-m-d H:i:s'))); ?> </td>
		</tr> 
		<?php
	endforeach;
	?>
</table>
<?php
/**
 * This hook is used to do extra after renewal order details table.
 *  
 * @since 2.8.0
 */
do_action('wal_auto_topup_after_renewal_order_details');
