<?php

/**
 * Modules Instances Class.
 * */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (!class_exists('WAL_Module_Instances')) {

	/**
	 * Class.
	 * */
	class WAL_Module_Instances {

		/**
		 * Modules.
		 * 
		 * @var array
		 * */
		private static $modules = array();

		/**
		 * Get the all modules.
		 * 
		 * @return array
		 * */
		public static function get_modules() {

			if (!self::$modules) {
				self::load_modules();
			}

			return self::$modules;
		}

		/**
		 * Load all Modules.
		 * */
		public static function load_modules() {

			if (!class_exists('WAL_Modules')) {
				include WAL_PLUGIN_PATH . '/inc/abstracts/abstract-wal-modules.php';
			}

			$default_module_classes = array(
				'fund-transfer' => 'WAL_Fund_Transfer_Module',
				'auto-topup' => 'WAL_Auto_Topup_Module',
				'gift-voucher' => 'WAL_Gift_Voucher_Module',
				'wallet-actions' => 'WAL_Wallet_Actions_Module',
				'wallet-withdrawal' => 'WAL_Wallet_Withdrawal_Module',
				'product-purchase' => 'WAL_Product_Purchase_Module',
					);

			foreach ($default_module_classes as $file_name => $module_class) {

				// Include module file.
				include 'class-' . $file_name . '.php';

				// Add module Object.
				self::add_module(new $module_class());
			}
		}

		/**
		 * Add a module.
		 * 
		 * */
		public static function add_module( $module ) {

			self::$modules[$module->get_id()] = $module;
		}

		/**
		 * Get the module by id.
		 * 
		 * @return object/bool
		 * */
		public static function get_module_by_id( $module_id ) {
			$modules = self::get_modules();

			return isset($modules[$module_id]) ? $modules[$module_id] : false;
		}

		/**
		 * Reset.
		 * */
		public static function reset() {
			self::$modules = null;
		}
	}

}
