<?php

/**
 * Short codes.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'WAL_Shortcodes' ) ) {

	/**
	 * Class.
	 */
	class WAL_Shortcodes {

		/**
		 * Class Initialization.
		 * */
		public static function init() {
			/**
			 * This hook is used to alter the short codes.
			 * 
			 * @since 1.0
			 */
			$shortcodes = apply_filters( 'wal_load_shortcodes', array(
				'wal_dashboard',
				'wal_overview',
				'wal_transaction_details',
				'wal_topup_form',
				'wal_fund_transaction_log',
				'wal_fund_transfer_form',
				'wal_fund_request_form',
				'wal_auto_topup_form',
				'wal_voucher_form',
				'wal_withdraw_transaction_log',
				'wal_withdraw_request_form',
				'wal_available_balance',
				'wal_total_usage',
				'wal_total_topup_amount',
				'wal_total_expired_amount',
				'wal_status',
				'wal_expiry_date',
				'wal_user_name',
				'wal_user_email',
				'wal_user_avatar',
					) ) ;

			foreach ( $shortcodes as $shortcode_name ) {
				// Add a shortcode.
				add_shortcode( $shortcode_name, array( __CLASS__, 'process_shortcode' ) ) ;
			}
		}

		/**
		 * Process the shortcode.
		 * 
		 * @return mixed
		 * */
		public static function process_shortcode( $atts, $content, $tag ) {
			$shortcode_name = str_replace( 'wal_', '', $tag ) ;
			$function       = 'shortcode_' . $shortcode_name ;

			switch ( $shortcode_name ) {
				case 'dashboard':
				case 'overview':
				case 'topup_form':
				case 'voucher_form':
				case 'fund_transaction_log':
				case 'auto_topup_form':
				case 'fund_transfer_form':
				case 'fund_request_form':
				case 'withdraw_request_form':
				case 'withdraw_transaction_log':
				case 'transaction_details':
					ob_start() ;
					self::$function( $atts, $content ) ; // output for shortcode.
					$content = ob_get_contents() ;
					ob_end_clean() ;
					break ;

				case 'available_balance':
				case 'total_usage':
				case 'total_topup_amount':
				case 'total_expired_amount':
				case 'status':
				case 'expiry_date':
				case 'user_name':
				case 'user_email':
				case 'user_avatar':
					$content = self::$function( $atts, $content ) ; // output for shortcode.
					break ;

				default:
					ob_start() ;
					/**
					 * This hook is used to display the short code content.
					 * 
					 * @since 1.0
					 */
					do_action( "wal_shortcode_{$shortcode_name}_content" ) ;
					$content = ob_get_contents() ;
					ob_end_clean() ;
					break ;
			}

			return $content ;// nosem
		}

		/**
		 * Display the content of dashboard.
		 * 
		 * @return void
		 * */
		public static function shortcode_dashboard( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				wal_get_template( 'dashboard/guest-notice.php' ) ;

				return ;
			}

			// For login user.
			global $wal_current_endpoint, $wp ;

			$menus = wal_dashboard_menus() ;
			if ( wal_check_is_array( $menus ) ) {
				foreach ( $menus as $endpoint => $menu ) {
					// Without submenu.
					if ( isset( $wp->query_vars[ $menu[ 'endpoint' ] ] ) && ! isset( $menu[ 'submenus' ] ) ) {
						$wal_current_endpoint = $endpoint ;
						break ;
						// With submenu.
					} elseif ( isset( $wp->query_vars[ $menu[ 'endpoint' ] ] ) && isset( $menu[ 'submenus' ] ) ) {
						$wal_current_endpoint = key( $menu[ 'submenus' ] ) ;
						break ;
					}

					// Return if the submenu not exists in menu.
					if ( ! isset( $menu[ 'submenus' ] ) || ! wal_check_is_array( $menu[ 'submenus' ] ) ) {
						continue ;
					}

					foreach ( $menu[ 'submenus' ] as $submenu_endpoint => $submneu ) {
						if ( isset( $wp->query_vars[ $submneu[ 'endpoint' ] ] ) ) {
							$wal_current_endpoint = $submenu_endpoint ;
							break ;
						}
					}
				}
			}

			if ( ! isset( $wal_current_endpoint ) ) {
				$wal_current_endpoint = key( $menus ) ;
			}

			// Display the notice when wallet is inactive.
			if ( 'wal_inactive' == WAL_Current_User_Wallet::get_status() ) {
				WAL_Dashboard_Handler::add_error( wal_get_wallet_inactive_admin_message() ) ;
			}

			wal_get_template( 'dashboard.php' ) ;
		}

		/**
		 * Display the content of top-up form.
		 * 
		 * @return void
		 * */
		public static function shortcode_topup_form( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				wal_get_template( 'dashboard/guest-notice.php' ) ;

				return ;
			}

			// For login user.
			WAL_Topup_Handler::render() ;
		}

		/**
		 * Display the content of voucher form.
		 * 
		 * @return void
		 * */
		public static function shortcode_voucher_form( $atts, $content ) {
			$gift_voucher_module = new WAL_Gift_Voucher_Module();
			$gift_voucher_module->gift_voucher_menu_content();
		}

		/**
		 * Display the content of transaction logs for Fund Transfer & Request
		 * 
		 * @return void
		 * */
		public static function shortcode_fund_transaction_log( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				wal_get_template( 'dashboard/guest-notice.php' ) ;

				return ;
			}

			$fund_transfer_module = new WAL_Fund_Transfer_Module();
			$fund_transfer_module->transactions_menu_content() ;
		}

		/**
		 * Display the content of fund transfer form.
		 * 
		 * @return void
		 * */
		public static function shortcode_fund_transfer_form( $atts, $content ) {
			global $wal_confirm_action;

			$fund_transfer_module = new WAL_Fund_Transfer_Module();
			$fund_transfer_module->fund_transfer_menu_content();
		}

		/**
		 * Display the content of fund request form.
		 * 
		 * @return void
		 * */
		public static function shortcode_fund_request_form( $atts, $content ) {
			$fund_transfer_module = new WAL_Fund_Transfer_Module();
			$fund_transfer_module->fund_request_menu_content();
		}

		/**
		 * Display the content of withdrawal transaction log.
		 * 
		 * @return void
		 * */
		public static function shortcode_withdraw_transaction_log( $atts, $content ) {
			$wallet_withdrawal_module = new WAL_Wallet_Withdrawal_Module();
			$wallet_withdrawal_module->wallet_withdrawal_transactions_menu_content();
		}

		/**
		 * Display the content of withdrawal request form.
		 * 
		 * @return void
		 * */
		public static function shortcode_withdraw_request_form( $atts, $content ) {
			$wallet_withdrawal_module = new WAL_Wallet_Withdrawal_Module();
			$wallet_withdrawal_module->wallet_withdrawal_request_menu_content();
		}

		/**
		 * Display the content of auto top-up form.
		 * 
		 * @return void
		 * */
		public static function shortcode_auto_topup_form( $atts, $content ) {
			$auto_topup_module = new WAL_Auto_Topup_Module();
			$auto_topup_module->render() ;
		}

		/**
		 * Display the content of Overview.
		 * 
		 * @return void
		 * */
		public static function shortcode_overview( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				wal_get_template( 'dashboard/guest-notice.php' ) ;

				return ;
			}

			// For login user.
			WAL_Dashboard_Handler::render_overview() ;
		}

		/**
		 * Display the content of transaction logs(Wallet Activity).
		 * 
		 * @return void
		 * */
		public static function shortcode_transaction_details( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				wal_get_template( 'dashboard/guest-notice.php' ) ;

				return ;
			}

			// For login user.
			WAL_Dashboard_Handler::render_activity() ;
		}

		/**
		 * Display the content of wallet available balance.
		 * 
		 * @return string
		 * */
		public static function shortcode_available_balance( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return wal_convert_price_by_currency( WAL_Current_User_Wallet::get_balance() ) ;
		}

		/**
		 * Display the content of wallet total usage.
		 * 
		 * @return string
		 * */
		public static function shortcode_total_usage( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return wal_convert_price_by_currency( WAL_Current_User_Wallet::get_usage_total() ) ;
		}

		/**
		 * Display the content of wallet total topup amount.
		 * 
		 * @return string
		 */
		public static function shortcode_total_topup_amount( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return wal_convert_price_by_currency( WAL_Current_User_Wallet::get_topup_total() ) ;
		}

		/**
		 * Display the content of wallet total expired amount.
		 *
		 * @return string
		 */
		public static function shortcode_total_expired_amount( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return wal_convert_price_by_currency( WAL_Current_User_Wallet::get_expired_total() ) ;
		}

		/**
		 * Display the content of wallet status.
		 * 
		 * @return string
		 * */
		public static function shortcode_status( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return wal_display_post_status( WAL_Current_User_Wallet::get_status() ) ;
		}

		/**
		 * Display the content of wallet expiry date.
		 * 
		 * @return string
		 * */
		public static function shortcode_expiry_date( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return WAL_Current_User_Wallet::get_expiry_date( true ) ;
		}

		/**
		 * Display the content of wallet user name.
		 * 
		 * @return string
		 * */
		public static function shortcode_user_name( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return WAL_Current_User_Wallet::get_user_name() ;
		}

		/**
		 * Display the content of wallet user email.
		 * 
		 * @return string
		 * */
		public static function shortcode_user_email( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return WAL_Current_User_Wallet::get_user_email() ;
		}

		/**
		 * Display the content of wallet user avatar.
		 * 
		 * @return string
		 * */
		public static function shortcode_user_avatar( $atts, $content ) {
			// For guest user.
			if ( ! is_user_logged_in() ) {
				return ;
			}

			return get_avatar( get_current_user_id(), 32 ) ;
		}
	}

	WAL_Shortcodes::init() ;
}
