<?php

/**
 *  Handles the Myaccount.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Myaccount_Handler' ) ) {

	/**
	 * Class.
	 * */
	class WAL_Myaccount_Handler {

		/**
		 * Wallet endpoint.
		 * 
		 * @var string
		 */
		public static $wallet_endpoint ;

		/**
		 * Class Initialization.
		 * */
		public static function init() {         
			add_action( 'plugins_loaded' , array( __CLASS__, 'handle_hooks' ) , 20 ) ;
		}

		/**
		 * Initialize the MyAccount menu hooks.
		 * 
		 * @return void
		 * */
		public static function handle_hooks() {
			if ( 'yes' == get_option( 'wal_general_hide_wallet_myaccount_menu' ) ) {
				return ;
			}

			self::$wallet_endpoint = wal_get_wallet_myaccount_menu_endpoint() ;

			//Add the custom rewrite endpoint.
			add_action( 'init' , array( __CLASS__, 'custom_rewrite_endpoint' ) ) ;
			//Flush rewrite rules.
			add_action( 'wp_loaded' , array( __CLASS__, 'flush_rewrite_rules' ) ) ;
			//Add the custom query vars.
			add_filter( 'query_vars' , array( __CLASS__, 'custom_query_vars' ) , 0 ) ;
			add_filter( 'woocommerce_get_query_vars' , array( __CLASS__, 'get_custom_query_vars' ) , 0 ) ;
			//Add the custom Myaccount Menu.
			add_filter( 'woocommerce_account_menu_items' , array( __CLASS__, 'custom_myaccount_menu' ) ) ;
			//Customize the custom myaccount menu title.
			add_filter( 'the_title' , array( __CLASS__, 'customize_menu_title' ) ) ;
			//Display the wallet menu content.
			add_action( 'woocommerce_account_' . self::$wallet_endpoint . '_endpoint' , array( __CLASS__, 'wallet_menu_content' ) , 10 ) ;
		}

		/**
		 * Add the custom rewrite endpoint.
		 * 
		 * @return void
		 * */
		public static function custom_rewrite_endpoint() {
			add_rewrite_endpoint( self::$wallet_endpoint , EP_ROOT | EP_PAGES ) ;
		}

		/**
		 * Flush rewrite rules.
		 * 
		 * @return void.
		 * */
		public static function flush_rewrite_rules() {
			flush_rewrite_rules() ;
		}

		/**
		 * Add the custom query variable.
		 * 
		 * @return array.
		 * */
		public static function custom_query_vars( $query_vars ) {
			
			$query_vars[] = self::$wallet_endpoint ;
			return $query_vars ;
		}

		/**
		 * Get custom query variable.
		 * 
		 * @since 4.3.0
		 * @return array.
		 * */
		public static function get_custom_query_vars( $query_vars ) {
			
			$query_vars[self::$wallet_endpoint] = self::$wallet_endpoint ;
			return $query_vars ;
		}

		/**
		 * Add the custom My account Menus.
		 * 
		 * @return array
		 */
		public static function custom_myaccount_menu( $menus ) {
			if ( ! is_user_logged_in() ) {
				return $menus ;
			}

			$custom_menu = array( self::$wallet_endpoint => wal_get_wallet_myaccount_menu_name_label() ) ;
						$position    = wal_get_wallet_myaccount_menu_position() ;

			return wal_customize_array_position( $menus , $position , $custom_menu ) ;
		}

		/**
		 * Customize the My account menu title.
		 * 
		 * @return string
		 */
		public static function customize_menu_title( $title ) {
			global $wp_query ;

			if ( is_main_query() && in_the_loop() && is_account_page() ) {
				if ( isset( $wp_query->query_vars[ self::$wallet_endpoint ] ) ) {
					$title = wal_get_wallet_myaccount_menu_name_label() ;
				}

				remove_filter( 'the_title' , array( __CLASS__, 'customize_menu_title' ) ) ;
			}

			return $title ;
		}

		/**
		 * Display the wallet menu content.
		 * 
		 * @return void
		 */
		public static function wallet_menu_content( $current_page ) {
			wal_get_template( 'myaccount/wallet-details.php' ) ;
		}
	}

	WAL_Myaccount_Handler::init() ;
}
