<?php

/**
 * Handles the wallet exports.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

/**
 * Include dependencies.
 */
if ( ! class_exists( 'WC_CSV_Exporter', false ) ) {
	require_once WC_ABSPATH . 'includes/export/abstract-wc-csv-exporter.php' ;
}

if ( ! class_exists( 'WAL_Wallet_Export_CSV' ) ) {

	/**
	 * Class.
	 */
	class WAL_Wallet_Export_CSV extends WC_CSV_Exporter {

		/**
		 * Type of export used in filter names.
		 *
		 * @var string
		 */
		protected $export_type = 'wallet' ;

		/**
		 * Filename to export to.
		 *
		 * @var string
		 */
		protected $filename = 'wallet.csv' ;

		/**
		 * Return default columns.
		 * 
		 * @return array
		 */
		public function get_default_column_names() {

			$headings = array(
				'username'     => __( 'Username', 'wallet-for-woocommerce' ),
				'user_email'   => __( 'User Email', 'wallet-for-woocommerce' ),
				'expiry_day'   => __( 'Expiry Day', 'wallet-for-woocommerce' ),
				'currency'     => __( 'Currency', 'wallet-for-woocommerce' ),
				'amount'       => __( 'Available Balance', 'wallet-for-woocommerce' ),
				'total'        => __( 'Usage Total', 'wallet-for-woocommerce' ),
				'status'       => __( 'Status', 'wallet-for-woocommerce' ),
				'created_date' => __( 'Created Date', 'wallet-for-woocommerce' ),
					) ;
			/**
			 * This hook is used to alter the wallet export heading.
			 * 
			 * @since 1.0
			 */
			return apply_filters( 'wal_wallet_export_heading', $headings ) ;
		}

		/**
		 * Prepare data that will be exported.
		 * 
		 * @return void.
		 */
		public function prepare_data_to_export() {
			// Prepare column names.
			$this->column_names = $this->get_default_column_names() ;

			$wallet_ids = $this->get_wallet_ids() ;
			foreach ( $wallet_ids as $wallet_id ) {

				$wallet = wal_get_wallet( $wallet_id ) ;
				if ( ! is_object( $wallet ) ) {
					continue ;
				}

				$this->row_data[] = self::generate_row_data( $wallet ) ;
			}
		}

		/**
		 * Get the wallet data.
		 * 
		 * @return array
		 */
		protected function generate_row_data( $wallet ) {
			$row = array(
				'username'     => $wallet->get_user_name(),
				'user_email'   => $wallet->get_user_email(),
				'expiry_day'   => $wallet->get_formatted_current_expiry_date(),
				'currency'     => get_woocommerce_currency(),
				'amount'       => $wallet->get_balance(),
				'total'        => $wallet->get_usage_total(),
				'status'       => wal_display_post_status( $wallet->get_status(), false ),
				'created_date' => $wallet->get_formatted_created_date(),
					) ;
			/**
			 * This hook is used to alter the wallet export row data.
			 * 
			 * @since 1.0
			 */
			return apply_filters( 'wal_wallet_export_row_data', $row ) ;
		}

		/**
		 * Get the wallet IDs.
		 * 
		 * @return array
		 */
		protected function get_wallet_ids() {
			$args = array(
				'post_type'   => WAL_Register_Post_Types::WALLET_POSTTYPE,
				'post_status' => wal_get_wallet_statuses(),
				'fields'      => 'ids',
				'numberposts' => '-1',
					) ;

			return get_posts( $args ) ;
		}
	}

}
