<?php

/**
 * Wallet entity.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Wallet' ) ) {

	/**
	 * Class.
	 */
	class WAL_Wallet extends WAL_Post {

		/**
		 * Post Type.
		 * 
		 * @var string
		 */
		protected $post_type = WAL_Register_Post_Types::WALLET_POSTTYPE ;

		/**
		 * Post Status.
		 * 
		 * @var string
		 */
		protected $post_status = 'wal_active' ;

		/**
		 * User ID.
		 * 
		 * @var int
		 */
		protected $user_id ;

		/**
		 * Created Date.
		 * 
		 * @var string
		 */
		protected $created_date ;

		/**
		 * Modified date.
		 *
		 * @var string
		 * @since 4.1.0
		 */
		public $modified_date;

		/**
		 * User.
		 * 
		 * @var object
		 */
		protected $user ;

		/**
		 * Meta data keys.
		 * 
		 * @var array
		 */
		protected $meta_data_keys = array(
			'wal_balance'                                => '',
			'wal_current_expiry_date'                    => '',
			'wal_previous_expiry_date'                   => '',
			'wal_currency'                               => '',
			'wal_withdrawal_payment_gateway'             => '',
			'wal_withdrawal_payment_gateway_credentials' => array(),
			'wal_usage_total'                            => '',
			'wal_expired_total'                          => '',
			'wal_topup_total'                            => '',
			'wal_received_total'                         => '',
			'wal_transferred_total'                      => '',
			'wal_withdrew_total'                         => '',
			'wal_last_activity_date'                     => '',
				) ;

		/**
		 * Prepare extra post data.
		 */
		protected function load_extra_postdata() {
			$this->user_id      = $this->post->post_parent ;
			$this->created_date = $this->post->post_date_gmt ;
			$this->modified_date = $this->post->post_modified_gmt ;
		}

		/**
		 * Get the user.
		 * 
		 * @return object
		 */
		public function get_user() {

			if ( isset( $this->user ) ) {
				return $this->user ;
			}

			$this->user = get_userdata( $this->get_user_id() ) ;

			return $this->user ;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_created_date() {
			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_created_date() ) ;
		}

		/**
		 * Get the formatted modified date time.
		 * 
		 * @since 4.1.0
		 * @return string
		 */
		public function get_formatted_modified_date() {
			if (! $this->get_modified_date()) {
				return '';
			}
			return WAL_Date_Time::get_wp_format_datetime($this->get_modified_date());
		}


		/**
		 * Get the formatted current expiry date time.
		 * 
		 * @return string
		 */
		public function get_formatted_current_expiry_date() {
			if ( ! $this->get_current_expiry_date() ) {
				return __( 'Never', 'wallet-for-woocommerce' ) ;
			}

			// Expired status.
			if ( 'wal_expired' == $this->get_status() ) {
				return '-' ;
			}

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_current_expiry_date() ) ;
		}

		/**
		 * Get the formatted last activity datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_last_activity_date() {
			if ( ! $this->get_last_activity_date() ) {
				return '-' ;
			}

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_last_activity_date() ) ;
		}
				
		/**
		 * Get the user name.
		 * 
		 * @return string
		 */
		public function get_user_name() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->display_name ;
		}

		/**
		 * Get the user email.
		 * 
		 * @return string
		 */
		public function get_user_email() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->user_email ;
		}

		/**
		 * Setters and Getters
		 */

		/**
		 * Set user ID.
		 */
		public function set_name( $value ) {
			$this->user_id = $value ;
		}

		/**
		 * Set created date.
		 */
		public function set_created_date( $value ) {
			$this->created_date = $value ;
		}

		/**
		 * Set modified date.
		 *
		 * @since 4.1.0
		 * @return string
		 */
		public function set_modified_date( $value ) {
			$this->modified_date = $value ;
		}


		/**
		 * Set balance.
		 */
		public function set_balance( $value ) {
			$this->set_prop( 'wal_balance', $value ) ;
		}

		/**
		 * Set current expiry date.
		 */
		public function set_current_expiry_date( $value ) {
			$this->set_prop( 'wal_current_expiry_date', $value ) ;
		}

		/**
		 * Set previous expiry date.
		 */
		public function set_previous_expiry_date( $value ) {
			$this->set_prop( 'wal_previous_expiry_date', $value ) ;
		}

		/**
		 * Set currency.
		 */
		public function set_currency( $value ) {
			$this->set_prop( 'wal_currency', $value ) ;
		}

		/**
		 * Set withdrawal payment gateway.
		 */
		public function set_withdrawal_payment_gateway( $value ) {
			$this->set_prop( 'wal_withdrawal_payment_gateway', $value ) ;
		}

		/**
		 * Set withdrawal payment gateway credentials.
		 */
		public function set_withdrawal_payment_gateway_credentials( $value ) {
			$this->set_prop( 'wal_withdrawal_payment_gateway_credentials', $value ) ;
		}

		/**
		 * Set usage total.
		 */
		public function set_usage_total( $value ) {
			$this->set_prop( 'wal_usage_total', $value ) ;
		}

		/**
		 * Set expired total.
		 */
		public function set_expired_total( $value ) {
			$this->set_prop( 'wal_expired_total', $value ) ;
		}

		/**
		 * Set topup total.
		 */
		public function set_topup_total( $value ) {
			$this->set_prop( 'wal_topup_total', $value ) ;
		}

		/**
		 * Set received total.
		 */
		public function set_received_total( $value ) {
			$this->set_prop( 'wal_received_total', $value ) ;
		}

		/**
		 * Set transferred total.
		 */
		public function set_transferred_total( $value ) {
			$this->set_prop( 'wal_transferred_total', $value ) ;
		}

		/**
		 * Set withdrew total.
		 */
		public function set_withdrew_total( $value ) {
			$this->set_prop( 'wal_withdrew_total', $value ) ;
		}

		/**
		 * Set last activity date.
		 */
		public function set_last_activity_date( $value ) {
			$this->set_prop( 'wal_last_activity_date', $value ) ;
		}

		/**
		 * Get user ID.
		 */
		public function get_user_id() {
			return $this->user_id ;
		}

		/**
		 * Get created date.
		 */
		public function get_created_date() {
			return $this->created_date ;
		}

		/**
		 * Get modified date.
		 *
		 * @since 4.1.0
		 * @return string
		 */
		public function get_modified_date() {
			return $this->modified_date ;
		}

		/**
		 * Get balance.
		 */
		public function get_balance() {
			return $this->get_prop( 'wal_balance' ) ;
		}

		/**
		 * Get current expiry date.
		 */
		public function get_current_expiry_date() {
			return $this->get_prop( 'wal_current_expiry_date' ) ;
		}

		/**
		 * Get previous expiry date.
		 */
		public function get_previous_expiry_date() {
			return $this->get_prop( 'wal_previous_expiry_date' ) ;
		}

		/**
		 * Get currency.
		 */
		public function get_currency() {
			return $this->get_prop( 'wal_currency' ) ;
		}

		/**
		 * Get withdrawal payment gateway.
		 */
		public function get_withdrawal_payment_gateway() {
			return $this->get_prop( 'wal_withdrawal_payment_gateway' ) ;
		}

		/**
		 * Get withdrawal payment gateway credentials.
		 */
		public function get_withdrawal_payment_gateway_credentials() {
			return $this->get_prop( 'wal_withdrawal_payment_gateway_credentials' ) ;
		}

		/**
		 * Get usage total.
		 */
		public function get_usage_total() {
			return $this->get_prop( 'wal_usage_total' ) ;
		}

		/**
		 * Get expired total.
		 */
		public function get_expired_total() {
			return $this->get_prop( 'wal_expired_total' ) ;
		}

		/**
		 * Get topup total.
		 */
		public function get_topup_total() {
			return $this->get_prop( 'wal_topup_total' ) ;
		}

		/**
		 * Get received total.
		 */
		public function get_received_total() {
			return $this->get_prop( 'wal_received_total' ) ;
		}

		/**
		 * Get transferred total.
		 */
		public function get_transferred_total() {
			return $this->get_prop( 'wal_transferred_total' ) ;
		}

		/**
		 * Get withdrew total.
		 */
		public function get_withdrew_total() {
			return $this->get_prop( 'wal_withdrew_total' ) ;
		}

		/**
		 * Get last activity date.
		 */
		public function get_last_activity_date() {
			return $this->get_prop( 'wal_last_activity_date' ) ;
		}
	}

}
