<?php

/**
 * Transaction Log.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Transaction_Log' ) ) {

	/**
	 * WAL_Transaction_Log Class.
	 */
	class WAL_Transaction_Log extends WAL_Post {

		/**
		 * Post Type.
		 * 
		 * @var string
		 */
		protected $post_type = WAL_Register_Post_Types::TRANSACTION_LOG_POSTTYPE ;

		/**
		 * Post Status.
		 * 
		 * @var string
		 */
		protected $post_status = 'wal_credit' ;

		/**
		 * Wallet ID.
		 * 
		 * @var int
		 */
		protected $wallet_id ;

		/**
		 * Created Date.
		 * 
		 * @var string
		 */
		protected $created_date ;

		/**
		 * Wallet.
		 * 
		 * @var object
		 */
		protected $wallet ;

		/**
		 * User.
		 * 
		 * @var object
		 */
		protected $user ;

		/**
		 * Meta data keys.
		 */
		protected $meta_data_keys = array(
			'wal_user_id'       => '',
			'wal_order_id'      => '',
			'wal_event_id'      => '',
			'wal_event_message' => '',
			'wal_amount'        => '',
			'wal_total'         => '',
			'wal_currency'      => '',
				) ;

		/**
		 * Prepare extra post data.
		 */
		protected function load_extra_postdata() {
			$this->wallet_id    = $this->post->post_parent ;
			$this->created_date = $this->post->post_date_gmt ;
		}

		/**
		 * Get the wallet.
		 * 
		 * @return object
		 */
		public function get_wallet() {
			if ( isset( $this->wallet ) ) {
				return $this->wallet ;
			}

			$this->wallet = wal_get_wallet( $this->get_wallet_id() ) ;

			return $this->wallet ;
		}

		/**
		 * Get the user.
		 * 
		 * @return object
		 */
		public function get_user() {

			if ( isset( $this->user ) ) {
				return $this->user ;
			}

			$this->user = get_userdata( $this->get_user_id() ) ;

			return $this->user ;
		}

		/**
		 * Get the user name.
		 * 
		 * @return string
		 */
		public function get_user_name() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->display_name ;
		}

		/**
		 * Get the user email.
		 * 
		 * @return string
		 */
		public function get_user_email() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->user_email ;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_created_date() {

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_created_date() ) ;
		}

		/**
		 * Get the formatted event message.
		 * 
		 * @return string
		 */
		public function get_formatted_event_message() {

			return $this->get_event_message() ;
		}

		/**
		 * Setters and Getters.
		 * */

		/**
		 * Set wallet ID
		 */
		public function set_wallet_id( $value ) {
			$this->wallet_id = $value ;
		}

		/**
		 * Set created date.
		 */
		public function set_created_date( $value ) {
			$this->created_date = $value ;
		}

		/**
		 * Set user ID.
		 * */
		public function set_user_id( $value ) {
			$this->set_prop( 'wal_user_id' , $value ) ;
		}

		/**
		 * Set order ID.
		 * */
		public function set_order_id( $value ) {
			$this->set_prop( 'wal_order_id' , $value ) ;
		}

		/**
		 * Set event ID.
		 */
		public function set_event_id( $value ) {
			$this->set_prop( 'wal_event_id' , $value ) ;
		}

		/**
		 * Set event message.
		 */
		public function set_event_message( $value ) {
			$this->set_prop( 'wal_event_message' , $value ) ;
		}

		/**
		 * Set amount.
		 */
		public function set_amount( $value ) {
			$this->set_prop( 'wal_amount' , $value ) ;
		}

		/**
		 * Set total.
		 */
		public function set_total( $value ) {
			$this->set_prop( 'wal_total' , $value ) ;
		}

		/**
		 * Set currency.
		 */
		public function set_currency( $value ) {
			$this->set_prop( 'wal_currency' , $value ) ;
		}

		/**
		 * Get wallet ID.
		 */
		public function get_wallet_id() {
			return $this->wallet_id ;
		}

		/**
		 * Get created date.
		 */
		public function get_created_date() {
			return $this->created_date ;
		}

		/**
		 * Get user ID.
		 */
		public function get_user_id() {
			return $this->get_prop( 'wal_user_id' ) ;
		}

		/**
		 * Get order ID.
		 */
		public function get_order_id() {
			return $this->get_prop( 'wal_order_id' ) ;
		}

		/**
		 * Get event ID.
		 */
		public function get_event_id() {
			return $this->get_prop( 'wal_event_id' ) ;
		}

		/**
		 * Get event message.
		 */
		public function get_event_message() {
			return $this->get_prop( 'wal_event_message' ) ;
		}

		/**
		 * Get amount.
		 */
		public function get_amount() {
			return $this->get_prop( 'wal_amount' ) ;
		}

		/**
		 * Get total.
		 */
		public function get_total() {
			return $this->get_prop( 'wal_total' ) ;
		}

		/**
		 * Get currency.
		 */
		public function get_currency() {
			return $this->get_prop( 'wal_currency' ) ;
		}
	}

}
