<?php

/**
 * Gift Voucher.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Gift_Voucher' ) ) {

	/**
	 * WAL_Gift_Voucher Class.
	 */
	class WAL_Gift_Voucher extends WAL_Post {

		/**
		 * Post Type.
		 * 
		 * @var string
		 */
		protected $post_type = WAL_Register_Post_Types::GIFT_VOUCHER_POSTTYPE ;

		/**
		 * Post Status.
		 * 
		 * @var string
		 */
		protected $post_status = 'wal_unused' ;

		/**
		 * Redeemed by.
		 * 
		 * @var int
		 */
		protected $redeemed_by ;

		/**
		 * Created Date.
		 * 
		 * @var string
		 */
		protected $created_date ;

		/**
		 * User.
		 * 
		 * @var object
		 */
		protected $user ;

		/**
		 * Meta data keys.
		 */
		protected $meta_data_keys = array(
			'wal_code'          => '',
			'wal_amount'        => '',
			'wal_currency'      => '',
			'wal_expiry_date'   => '',
			'wal_redeemed_date' => '',
				) ;

		/**
		 * Prepare extra post data.
		 */
		protected function load_extra_postdata() {
			$this->redeemed_by  = $this->post->post_parent ;
			$this->created_date = $this->post->post_date_gmt ;
		}

		/**
		 * Get the user.
		 * 
		 * @return object
		 */
		public function get_user() {

			if ( isset( $this->user ) ) {
				return $this->user ;
			}

			$this->user = get_userdata( $this->get_redeemed_by() ) ;

			return $this->user ;
		}

		/**
		 * Get the user name.
		 * 
		 * @return string
		 */
		public function get_user_name() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->display_name ;
		}

		/**
		 * Get the user email.
		 * 
		 * @return string
		 */
		public function get_user_email() {
			if ( ! is_object( $this->get_user() ) ) {
				return '' ;
			}

			return $this->get_user()->user_email ;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_created_date() {

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_created_date() ) ;
		}

		/**
		 * Get the formatted redeemed datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_redeemed_date() {
			if ( ! $this->get_redeemed_date() ) {
				return '' ;
			}

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_redeemed_date() ) ;
		}

		/**
		 * Get the formatted expiry datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_expiry_date() {
			if ( ! $this->get_expiry_date() ) {
				return __( 'Never' , 'wallet-for-woocommerce' ) ;
			}

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_expiry_date() ) ;
		}

		/**
		 * Setters and Getters.
		 * */

		/**
		 * Set redeemed by.
		 */
		public function set_redeemed_by( $value ) {
			$this->redeemed_by = $value ;
		}

		/**
		 * Set created date.
		 */
		public function set_created_date( $value ) {
			$this->created_date = $value ;
		}

		/**
		 * Set code.
		 * */
		public function set_code( $value ) {
			$this->set_prop( 'wal_code' , $value ) ;
		}

		/**
		 * Set amount.
		 * */
		public function set_amount( $value ) {
			$this->set_prop( 'wal_amount' , $value ) ;
		}

		/**
		 * Set currency.
		 */
		public function set_currency( $value ) {
			$this->set_prop( 'wal_currency' , $value ) ;
		}

		/**
		 * Set expiry date.
		 */
		public function set_expiry_date( $value ) {
			$this->set_prop( 'wal_expiry_date' , $value ) ;
		}

		/**
		 * Set redeemed date.
		 */
		public function set_redeemed_date( $value ) {
			$this->set_prop( 'wal_redeemed_date' , $value ) ;
		}

		/**
		 * Get redeemed by.
		 */
		public function get_redeemed_by() {
			return $this->redeemed_by ;
		}

		/**
		 * Get created date.
		 */
		public function get_created_date() {
			return $this->created_date ;
		}

		/**
		 * Get code.
		 */
		public function get_code() {
			return $this->get_prop( 'wal_code' ) ;
		}

		/**
		 * Get amount.
		 */
		public function get_amount() {
			return $this->get_prop( 'wal_amount' ) ;
		}

		/**
		 * Get currency.
		 */
		public function get_currency() {
			return $this->get_prop( 'wal_currency' ) ;
		}

		/**
		 * Get expiry date.
		 */
		public function get_expiry_date() {
			return $this->get_prop( 'wal_expiry_date' ) ;
		}

		/**
		 * Get redeemed date.
		 */
		public function get_redeemed_date() {
			return $this->get_prop( 'wal_redeemed_date' ) ;
		}
	}

}
