<?php

/**
 * Fund Transfer.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Fund_Transfer' ) ) {

	/**
	 * Class.
	 */
	class WAL_Fund_Transfer extends WAL_Post {

		/**
		 * Post Type.
		 * 
		 * @var string
		 */
		protected $post_type = WAL_Register_Post_Types::FUND_TRANSFER_POSTTYPE ;

		/**
		 * Post Status.
		 * 
		 * @var string
		 */
		protected $post_status = 'wal_transfered' ;

		/**
		 * Sender ID.
		 * 
		 * @var int
		 */
		protected $sender_id ;

		/**
		 * Receiver ID.
		 * 
		 * @var int
		 */
		protected $receiver_id ;

		/**
		 * Created Date.
		 * 
		 * @var string
		 */
		protected $created_date ;

		/**
		 * Sender.
		 * 
		 * @var object
		 */
		protected $sender ;

		/**
		 * Receiver.
		 * 
		 * @var object
		 */
		protected $receiver ;

		/**
		 * Meta data keys.
		 */
		protected $meta_data_keys = array(
			'wal_transfered_total'   => '',
			'wal_received_total'     => '',
			'wal_requested_total'    => '',
			'wal_currency'           => '',
			'wal_last_activity_date' => '',
				) ;

		/**
		 * Prepare extra post data.
		 */
		protected function load_extra_postdata() {
			$this->sender_id    = $this->post->post_author ;
			$this->receiver_id  = $this->post->post_parent ;
			$this->created_date = $this->post->post_date_gmt ;
		}

		/**
		 * Get the sender.
		 * 
		 * @return object
		 */
		public function get_sender() {
			if ( isset( $this->sender ) ) {
				return $this->sender ;
			}

			$this->sender = get_userdata( $this->get_sender_id() ) ;

			return $this->sender ;
		}

		/**
		 * Get the receiver.
		 * 
		 * @return object
		 */
		public function get_receiver() {
			if ( isset( $this->receiver ) ) {
				return $this->receiver ;
			}

			$this->receiver = get_userdata( $this->get_receiver_id() ) ;

			return $this->receiver ;
		}

		/**
		 * Get the sender user name.
		 * 
		 * @return string
		 */
		public function get_sender_user_name() {
			if ( ! is_object( $this->get_sender() ) ) {
				return '' ;
			}

			return $this->get_sender()->display_name ;
		}

		/**
		 * Get the sender user email.
		 * 
		 * @return string
		 */
		public function get_sender_user_email() {
			if ( ! is_object( $this->get_sender() ) ) {
				return '' ;
			}

			return $this->get_sender()->user_email ;
		}

		/**
		 * Get the receiver user name.
		 * 
		 * @return string
		 */
		public function get_receiver_user_name() {
			if ( ! is_object( $this->get_receiver() ) ) {
				return '' ;
			}

			return $this->get_receiver()->display_name ;
		}

		/**
		 * Get the receiver user email.
		 * 
		 * @return string
		 */
		public function get_receiver_user_email() {
			if ( ! is_object( $this->get_receiver() ) ) {
				return '' ;
			}

			return $this->get_receiver()->user_email ;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_created_date() {

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_created_date() ) ;
		}

		/**
		 * Get the formatted last activity datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_last_activity_date() {

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_last_activity_date() ) ;
		}

		/**
		 * Setters and Getters.
		 * */

		/**
		 * Set sender ID
		 */
		public function set_sender_id( $value ) {
			$this->sender_id = $value ;
		}

		/**
		 * Set receiver ID.
		 * */
		public function set_receiver_id( $value ) {
			$this->receiver_id = $value ;
		}

		/**
		 * Set created date.
		 */
		public function set_created_date( $value ) {
			$this->created_date = $value ;
		}

		/**
		 * Set transfered total.
		 * */
		public function set_transfered_total( $value ) {
			$this->set_prop( 'wal_transfered_total' , $value ) ;
		}

		/**
		 * Set received total.
		 */
		public function set_received_total( $value ) {
			$this->set_prop( 'wal_received_total' , $value ) ;
		}

		/**
		 * Set requested total.
		 */
		public function set_requested_total( $value ) {
			$this->set_prop( 'wal_requested_total' , $value ) ;
		}

		/**
		 * Set last activity date.
		 */
		public function set_last_activity_date( $value ) {
			$this->set_prop( 'wal_last_activity_date' , $value ) ;
		}

		/**
		 * Set currency.
		 */
		public function set_currency( $value ) {
			$this->set_prop( 'wal_currency' , $value ) ;
		}

		/**
		 * Get sender ID.
		 */
		public function get_sender_id() {
			return $this->sender_id ;
		}

		/**
		 * Get receiver ID.
		 */
		public function get_receiver_id() {
			return $this->receiver_id ;
		}

		/**
		 * Get created date.
		 */
		public function get_created_date() {
			return $this->created_date ;
		}

		/**
		 * Get transfered total.
		 */
		public function get_transfered_total() {
			return $this->get_prop( 'wal_transfered_total' ) ;
		}

		/**
		 * Get received total.
		 */
		public function get_received_total() {
			return $this->get_prop( 'wal_received_total' ) ;
		}

		/**
		 * Get requested total.
		 */
		public function get_requested_total() {
			return $this->get_prop( 'wal_requested_total' ) ;
		}

		/**
		 * Get last activity date.
		 */
		public function get_last_activity_date() {
			return $this->get_prop( 'wal_last_activity_date' ) ;
		}

		/**
		 * Get currency.
		 */
		public function get_currency() {
			return $this->get_prop( 'wal_currency' ) ;
		}
	}

}
