<?php

/**
 * Fund Transfer Log.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Fund_Transfer_Log' ) ) {

	/**
	 * Class.
	 */
	class WAL_Fund_Transfer_Log extends WAL_Post {

		/**
		 * Post Type.
		 * 
		 * @var string
		 */
		protected $post_type = WAL_Register_Post_Types::FUND_TRANSFER_LOG_POSTTYPE ;

		/**
		 * Post Status.
		 * 
		 * @var string
		 */
		protected $post_status = 'wal_transfered' ;

		/**
		 * Sender ID.
		 * 
		 * @var int
		 */
		protected $sender_id ;

		/**
		 * Sender Transfer ID.
		 * 
		 * @var int
		 */
		protected $sender_transfer_id ;

		/**
		 * Created Date.
		 * 
		 * @var string
		 */
		protected $created_date ;

		/**
		 * Sender.
		 * 
		 * @var object
		 */
		protected $sender ;

		/**
		 * Receiver.
		 * 
		 * @var object
		 */
		protected $receiver ;

		/**
		 * Sender Transfer.
		 * 
		 * @var object
		 */
		protected $sender_transfer ;

		/**
		 * Receiver Transfer.
		 * 
		 * @var object
		 */
		protected $receiver_transfer ;

		/**
		 * Meta data keys.
		 */
		protected $meta_data_keys = array(
			'wal_receiver_id'          => '',
			'wal_receiver_transfer_id' => '',
			'wal_receiver_log_id'      => '',
			'wal_amount'               => '',
			'wal_fee'                  => '',
			'wal_currency'             => '',
			'wal_reason'               => '',
			'wal_sent_by'              => '',
				) ;

		/**
		 * Prepare extra post data.
		 */
		protected function load_extra_postdata() {
			$this->sender_id          = $this->post->post_author ;
			$this->sender_transfer_id = $this->post->post_parent ;
			$this->created_date       = $this->post->post_date_gmt ;
		}

		/**
		 * Get the sender.
		 * 
		 * @return object
		 */
		public function get_sender() {
			if ( isset( $this->sender ) ) {
				return $this->sender ;
			}

			$this->sender = get_userdata( $this->get_sender_id() ) ;

			return $this->sender ;
		}

		/**
		 * Get the receiver.
		 * 
		 * @return object
		 */
		public function get_receiver() {
			if ( isset( $this->receiver ) ) {
				return $this->receiver ;
			}

			$this->receiver = get_userdata( $this->get_receiver_id() ) ;

			return $this->receiver ;
		}

		/**
		 * Get the sender transfer.
		 * 
		 * @return object
		 */
		public function get_sender_transfer() {

			if ( $this->sender_transfer ) {
				return $this->sender_transfer ;
			}

			$this->sender_transaction = wal_get_fund_transfer( $this->get_sender_transfer_id() ) ;

			return $this->sender_transaction ;
		}

		/**
		 * Get the receiver transfer.
		 * 
		 * @return object
		 */
		public function get_receiver_transfer() {

			if ( $this->receiver_transfer ) {
				return $this->receiver_transfer ;
			}

			$this->receiver_transaction = wal_get_fund_transfer( $this->get_receiver_transfer_id() ) ;

			return $this->receiver_transfer ;
		}

		/**
		 * Get the formatted created datetime.
		 * 
		 * @return string
		 */
		public function get_formatted_created_date() {

			return WAL_Date_Time::get_wp_format_datetime_from_gmt( $this->get_created_date() ) ;
		}

		/**
		 * Setters and Getters.
		 * */

		/**
		 * Set sender ID
		 */
		public function set_sender_id( $value ) {
			$this->sender_id = $value ;
		}

		/**
		 * Set receiver ID.
		 * */
		public function set_receiver_id( $value ) {
			$this->set_prop( 'wal_receiver_id' , $value ) ;
		}

		/**
		 * Set sender transfer ID.
		 * */
		public function set_sender_transfer_id( $value ) {
			$this->sender_transfer_id = $value ;
		}

		/**
		 * Set created date.
		 */
		public function set_created_date( $value ) {
			$this->created_date = $value ;
		}

		/**
		 * Set receiver transfer ID.
		 */
		public function set_receiver_transfer_id( $value ) {
			$this->set_prop( 'wal_receiver_transfer_id' , $value ) ;
		}

		/**
		 * Set receiver log ID.
		 */
		public function set_receiver_log_id( $value ) {
			$this->set_prop( 'wal_receiver_log_id' , $value ) ;
		}

		/**
		 * Set amount.
		 */
		public function set_amount( $value ) {
			$this->set_prop( 'wal_amount' , $value ) ;
		}

		/**
		 * Set fee.
		 */
		public function set_fee( $value ) {
			$this->set_prop( 'wal_fee' , $value ) ;
		}

		/**
		 * Set currency.
		 */
		public function set_currency( $value ) {
			$this->set_prop( 'wal_currency' , $value ) ;
		}

		/**
		 * Set reason.
		 */
		public function set_reason( $value ) {
			$this->set_prop( 'wal_reason' , $value ) ;
		}

		/**
		 * Set sent by.
		 */
		public function set_sent_by( $value ) {
			$this->set_prop( 'wal_sent_by' , $value ) ;
		}

		/**
		 * Get sender ID.
		 */
		public function get_sender_id() {
			return $this->sender_id ;
		}

		/**
		 * Get receiver ID.
		 */
		public function get_receiver_id() {
			return $this->get_prop( 'wal_receiver_id' ) ;
		}

		/**
		 * Get sender transfer ID.
		 */
		public function get_sender_transfer_id() {
			return $this->sender_transfer_id ;
		}

		/**
		 * Get created date.
		 */
		public function get_created_date() {
			return $this->created_date ;
		}

		/**
		 * Get receiver transfer ID.
		 */
		public function get_receiver_transfer_id() {
			return $this->get_prop( 'wal_receiver_transfer_id' ) ;
		}

		/**
		 * Get receiver log ID.
		 */
		public function get_receiver_log_id() {
			return $this->get_prop( 'wal_receiver_log_id' ) ;
		}

		/**
		 * Get amount.
		 */
		public function get_amount() {
			return $this->get_prop( 'wal_amount' ) ;
		}

		/**
		 * Get fee.
		 */
		public function get_fee() {
			return $this->get_prop( 'wal_fee' ) ;
		}

		/**
		 * Get currency.
		 */
		public function get_currency() {
			return $this->get_prop( 'wal_currency' ) ;
		}

		/**
		 * Get reason.
		 */
		public function get_reason() {
			return $this->get_prop( 'wal_reason' ) ;
		}

		/**
		 * Get sent by.
		 */
		public function get_sent_by() {
			return $this->get_prop( 'wal_sent_by' ) ;
		}
	}

}
