<?php

/**
 * Register Custom Post Status.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Register_Post_Status' ) ) {

	/**
	 * Class.
	 */
	class WAL_Register_Post_Status {

		/**
		 * Class initialization.
		 */
		public static function init() {
			add_action( 'init', array( __CLASS__, 'register_custom_post_status' ) ) ;
		}

		/**
		 * Register custom post status.
		 * 
		 * @return void
		 */
		public static function register_custom_post_status() {
			$custom_post_statuses = array(
				'wal_active'           => array( 'WAL_Register_Post_Status', 'active_post_status_args' ),
				'wal_inactive'         => array( 'WAL_Register_Post_Status', 'inactive_post_status_args' ),
				'wal_expired'          => array( 'WAL_Register_Post_Status', 'expired_post_status_args' ),
				'wal_credit'           => array( 'WAL_Register_Post_Status', 'credit_post_status_args' ),
				'wal_debit'            => array( 'WAL_Register_Post_Status', 'debit_post_status_args' ),
				'wal_transfered'       => array( 'WAL_Register_Post_Status', 'transfered_post_status_args' ),
				'wal_received'         => array( 'WAL_Register_Post_Status', 'received_post_status_args' ),
				'wal_request_received' => array( 'WAL_Register_Post_Status', 'request_received_post_status_args' ),
				'wal_requested'        => array( 'WAL_Register_Post_Status', 'requested_post_status_args' ),
				'wal_request_declined' => array( 'WAL_Register_Post_Status', 'request_declined_post_status_args' ),
				'wal_cancelled'        => array( 'WAL_Register_Post_Status', 'cancelled_post_status_args' ),
				'wal_request_cancel'   => array( 'WAL_Register_Post_Status', 'request_cancelled_post_status_args' ),
				'wal_unused'           => array( 'WAL_Register_Post_Status', 'unused_post_status_args' ),
				'wal_used'             => array( 'WAL_Register_Post_Status', 'used_post_status_args' ),
				'wal_pending'          => array( 'WAL_Register_Post_Status', 'pending_post_status_args' ),
				'wal_approved'         => array( 'WAL_Register_Post_Status', 'approved_post_status_args' ),
					) ;
			/**
			 * This hook is used to alter the custom post statuses.
			 * 
			 * @since 1.0
			 */
			$custom_post_statuses = apply_filters( 'wal_add_custom_post_status', $custom_post_statuses ) ;

			// Return if no post status have to register.
			if ( ! wal_check_is_array( $custom_post_statuses ) ) {
				return ;
			}

			foreach ( $custom_post_statuses as $post_status => $args_function ) {

				$args = array() ;
				if ( $args_function ) {
					$args = call_user_func_array( $args_function, array() ) ;
				}

				// Register a post status.
				register_post_status( $post_status, $args ) ;
			}
		}

		/**
		 * Active custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function active_post_status_args() {
			/**
			 * This hook is used to alter the active post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_active_post_status_args', array(
				'label'                     => __( 'Active', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Active <span class="count">(%s)</span>', 'Active <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Inactive custom post status arguments.
		 * 
		 * @return array
		 */
		public static function inactive_post_status_args() {
			/**
			 * This hook is used to alter the In-active post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_inactive_post_status_args', array(
				'label'                     => __( 'Disabled', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Disabled <span class="count">(%s)</span>', 'Disabled <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Expired custom post status arguments.
		 * 
		 * @return array
		 */
		public static function expired_post_status_args() {
			/**
			 * This hook is used to alter the expired post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_expired_post_status_args', array(
				'label'                     => __( 'Expired', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Expired <span class="count">(%s)</span>', 'Expired <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Credit custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function credit_post_status_args() {
			/**
			 * This hook is used to alter the credit post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_credit_post_status_args', array(
				'label'                     => __( 'Credit', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Credit <span class="count">(%s)</span>', 'Credit <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Debit custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function debit_post_status_args() {
			/**
			 * This hook is used to alter the debit post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_debit_post_status_args', array(
				'label'                     => __( 'Debit', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Debit <span class="count">(%s)</span>', 'Debit <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Transfered custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function transfered_post_status_args() {
			/**
			 * This hook is used to alter the transferred post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_transfered_post_status_args', array(
				'label'                     => __( 'Fund Transferred', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Fund Transferred <span class="count">(%s)</span>', 'Fund Transferred <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Received custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function received_post_status_args() {
			/**
			 * This hook is used to alter the received post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_received_post_status_args', array(
				'label'                     => __( 'Fund Received', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Fund Received <span class="count">(%s)</span>', 'Fund Received <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Request received custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function request_received_post_status_args() {
			/**
			 * This hook is used to alter the request received post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_request_received_post_status_args', array(
				'label'                     => __( 'Request Received', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Request Received <span class="count">(%s)</span>', 'Request Received <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Requested custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function requested_post_status_args() {
			/**
			 * This hook is used to alter the requested post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_requested_post_status_args', array(
				'label'                     => __( 'Request Sent', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Request Sent <span class="count">(%s)</span>', 'Request Sent <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Request Declined custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function request_declined_post_status_args() {
			/**
			 * This hook is used to alter the declined post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_request_declined_post_status_args', array(
				'label'                     => __( 'Request Declined', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Request Declined <span class="count">(%s)</span>', 'Request Declined <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Cancelled custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function cancelled_post_status_args() {
			/**
			 * This hook is used to alter the cancelled post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_cancelled_post_status_args', array(
				'label'                     => __( 'Cancelled', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Cancelled <span class="count">(%s)</span>', 'Cancelled <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Request Cancelled custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function request_cancelled_post_status_args() {
			/**
			 * This hook is used to alter the request cancelled post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_request_cancelled_post_status_args', array(
				'label'                     => __( 'Request Cancelled', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Request Cancelled <span class="count">(%s)</span>', 'Request Cancelled <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Unused custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function unused_post_status_args() {
			/**
			 * This hook is used to alter the unused post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_unused_post_status_args', array(
				'label'                     => __( 'Unused', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Unused <span class="count">(%s)</span>', 'Unused <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Used custom post status arguments.
		 * 
		 * @retrun array
		 */
		public static function used_post_status_args() {
			/**
			 * This hook is used to alter the used post status arguments.
			 * 
			 * @since 1.0
			 */
			$args = apply_filters(
					'wal_used_post_status_args', array(
				'label'                     => __( 'Used', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Used <span class="count">(%s)</span>', 'Used <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Pending custom post status arguments.
		 * 
		 * @since 1.8
		 * 
		 * @retrun array
		 */
		public static function pending_post_status_args() {
			/**
			 * This hook is used to alter the pending post status arguments.
			 * 
			 * @since 1.8
			 * 
			 * @param array
			 */
			$args = apply_filters(
					'wal_pending_post_status_args', array(
				'label'                     => __( 'Pending', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Pending <span class="count">(%s)</span>', 'Pending <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}

		/**
		 * Approved custom post status arguments.
		 * 
		 * @since 1.8
		 * 
		 * @retrun array
		 */
		public static function approved_post_status_args() {
			/**
			 * This hook is used to alter the approved post status arguments.
			 * 
			 * @since 1.8
			 * 
			 * @param array
			 */
			$args = apply_filters(
					'wal_approved_post_status_args', array(
				'label'                     => __( 'Approved', 'wallet-for-woocommerce' ),
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				/* translators: %s: count */
				'label_count'               => _n_noop( 'Approved <span class="count">(%s)</span>', 'Approved <span class="count">(%s)</span>', 'wallet-for-woocommerce' ),
					)
					) ;

			return $args ;
		}
	}

	WAL_Register_Post_Status::init() ;
}
