<?php

/**
 * Pages.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'WAL_Pages' ) ) {

	/**
	 * Class.
	 */
	class WAL_Pages {

		/**
		 * Plugin Slug.
		 * 
		 * @var string
		 */
		protected static $plugin_slug = 'wal' ;

		/**
		 * Class Initialization.
		 * */
		public static function init() {
			add_filter( 'display_post_states', array( __CLASS__, 'post_states' ), 10, 2 ) ;
		}

		/**
		 * Create pages.
		 * */
		public static function create_pages() {
			/**
			 * This hook is used to alter the pages.
			 * 
			 * @since 1.0
			 */
			$pages = apply_filters(
					self::$plugin_slug . '_create_pages', array(
				'auction' => array(
					'name'    => _x( 'dashboard', 'Page slug', 'wallet-for-woocommerce' ),
					'title'   => _x( 'Wallet Dashboard', 'Page title', 'wallet-for-woocommerce' ),
					'content' => '[wal_dashboard]',
					'option'  => 'woocommerce_wal_dashboard_page_id',
					),
					)
					) ;

			foreach ( $pages as $page_args ) {
				self::create( $page_args ) ;
			}
		}

		/**
		 * Creat a page based on arguments.
		 * 
		 * @return int
		 * */
		public static function create( $page_args = array() ) {

			$defalut_page_args = array(
				'name'    => '',
				'title'   => '',
				'content' => '',
				'option'  => '',
					) ;

			$page_args = wp_parse_args( $page_args, $defalut_page_args ) ;

			// Check if the page is already created. 
			$option_value = get_option( $page_args[ 'option' ] ) ;
			$page_object  = get_post( $option_value ) ;
			if ( ! empty( $page_args[ 'option' ] ) && $page_object ) {
				if ( 'page' == $page_object->post_type ) {
					if ( ! in_array( $page_object->post_status, array( 'pending', 'trash', 'future', 'auto-draft' ) ) ) {
						return $page_object->ID ;
					}
				}
			}

			// Create a new page.
			$page_data = array(
				'post_status'    => 'publish',
				'post_type'      => 'page',
				'post_author'    => 1,
				'post_name'      => esc_sql( $page_args[ 'name' ] ),
				'post_title'     => $page_args[ 'title' ],
				'post_content'   => $page_args[ 'content' ],
				'comment_status' => 'closed',
					) ;

			$page_id = wp_insert_post( $page_data ) ;

			// Update page id.
			if ( $page_args[ 'option' ] ) {
				update_option( $page_args[ 'option' ], $page_id ) ;
			}

			return $page_id ;
		}

		/**
		 * Denotes the post states as such in the pages list table.
		 * 
		 * @return array
		 * */
		public static function post_states( $post_states, $post ) {
			if ( wc_get_page_id( 'wal_dashboard' ) != $post->ID ) {
				return $post_states ;
			}

			$post_states[ self::$plugin_slug . '_dashboard' ] = __( 'Wallet Dashboard', 'wallet-for-woocommerce' ) ;

			return $post_states ;
		}
	}

	WAL_Pages::init() ;
}
