<?php
/**
 * Wallet withdrawal status meta box.
 * 
 * @since 1.8
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}
?>
<div class="submitbox wal-wallet-withdrawal-status" id="submitpost">

	<div id="minor-publishing">
		<div id="misc-publishing-actions">
			<label><?php esc_html_e( 'Status', 'wallet-for-woocommerce' ) ; ?></label>
			<select name="post_status" class="post_status wal-withdrawal-status">
				<option value=""><?php esc_html_e( 'Change Status', 'wallet-for-woocommerce' ) ; ?></option>
				<?php
				$statuses = wal_get_wallet_withdrawal_edit_post_stauses($wal_withdrawal->get_status());
				if (wal_check_is_array($statuses)) :
					foreach ($statuses as $status_id => $label) :                    
						if ($status_id === $wal_withdrawal->get_status()) {
							continue;
						}
						?>
						<option value="<?php echo esc_attr( $status_id ) ; ?>"><?php echo esc_html( $label ) ; ?></option>
						<?php
					endforeach ;
				endif ;
				?>
			</select>
		</div>
	</div>

	<div id='wal-wallet-withdrawal-cancel-reason-content'>       
		<label><?php esc_html_e('Reason to Cancel', 'wallet-for-woocommerce'); ?></label>          
		<textarea name='wal_withdrawal_cancelled_reason' rows='4' cols='25'><?php echo wp_kses_post($wal_withdrawal->get_cancelled_reason()); ?></textarea>
	</div>

	<div id="major-publishing-actions">
		<div id="publishing-action">
			<input type="submit" class="button button-primary tips" name="publish" value="<?php esc_attr_e( 'Save', 'wallet-for-woocommerce' ) ; ?>" data-tip="<?php esc_html_e( 'Save/Update', 'wallet-for-woocommerce' ) ; ?>" />
		</div>
		<div class="clear"></div>
	</div>

	<?php wp_nonce_field( 'wal_save_data', 'wal_meta_nonce' ) ; ?>
</div>
<?php
