<?php
/**
 * Wallet withdrawal data meta box.
 * 
 * @since 1.8
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}
?>
<div class="wal-wallet-withdrawal-data-wrapper">
	<div class="wal-wallet-withdrawal-heading">
		<span class="wal-wallet-withdrawal-title">
			<?php
			/* translators: %s - ID */
			echo wp_kses_post( sprintf( __( 'Withdrawal ID - #%s', 'wallet-for-woocommerce' ), esc_html( $wal_withdrawal->get_id() ) ) ) ;
			?>
		</span>
		<span class="wal-wallet-withdrawal-status"><?php echo wp_kses_post( wal_display_post_status( $wal_withdrawal->get_status() ) ) ; ?></span>
	</div>

	<div class="wal-withdrawal-request-data">
		<h3><?php esc_html_e( 'Requested Details', 'wallet-for-woocommerce' ) ; ?></h3>
		<p>
			<label> <?php esc_html_e( 'User Name', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( $wal_withdrawal->get_user_name() ) ; ?></span>
		</p>
		<p>
			<label> <?php esc_html_e( 'User Email', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( $wal_withdrawal->get_user_email() ) ; ?></span>
		</p>
		<p>
			<label> <?php esc_html_e( 'Amount', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( wal_price( $wal_withdrawal->get_amount() , array( 'currency'=>$wal_withdrawal->get_currency() ) ) ) ; ?></span>
		</p>

		<p>
			<label> <?php esc_html_e( 'Fee', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( wal_price( $wal_withdrawal->get_fee() , array( 'currency'=>$wal_withdrawal->get_currency() ) ) ) ; ?></span>
		</p>

		<p>
			<label> <?php esc_html_e( 'Total', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( wal_price( $wal_withdrawal->get_total() , array( 'currency'=>$wal_withdrawal->get_currency() ) ) ) ; ?></span>
		</p>

		<p>
			<label> <?php esc_html_e( 'Created Date', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( $wal_withdrawal->get_formatted_created_date() ) ; ?></span>
		</p>

	</div>

	<div class="wal-withdrawal-request-payment-data">
		<h3><?php esc_html_e( 'Payment Details', 'wallet-for-woocommerce' ) ; ?></h3>
		<p>
			<label> <?php esc_html_e( 'Payment Method', 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( $wal_withdrawal->get_payment_gateway_title() ) ; ?></span>
		</p>
		<?php
		$credentials = $wal_withdrawal->get_formatted_payment_gateway_credentials() ;
		if ( wal_check_is_array( $credentials ) ) :
			?>
			<div class="wal-withdrawal-request-payment-details">
				<?php foreach ( $credentials as $credential ) : ?>
					<p>
						<label> <?php echo esc_html( $credential[ 'label' ] ) ; ?></label>
						<span><?php echo wp_kses_post( $credential[ 'value' ] ) ; ?></span>
					</p>
				<?php endforeach ; ?>
			</div>
		<?php endif ; ?>
	</div>

	<?php if ('wal_cancelled' === $wal_withdrawal->get_status()) : ?>
		<div class="wal-withdrawal-cancelled-reason-data">
			<h3><?php esc_html_e('Cancelled Reason', 'wallet-for-woocommerce'); ?></h3>			
			<p>
				<label> <?php esc_html_e('Reason', 'wallet-for-woocommerce'); ?></label>
				<span><?php echo esc_textarea(!empty($wal_withdrawal->get_cancelled_reason()) ? $wal_withdrawal->get_cancelled_reason() : '-'); ?></span>
			</p>
		</div>
	<?php endif; ?>

</div>
<?php
