<?php
/**
 * Wallet Panels.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}
?>
<div id="wal-wallet-data">
	<div class="wal-wallet-data-panels-wrapper">
	<a class="page-title-action wal-page-title-action" href="<?php echo esc_url( wal_get_user_transaction_logs_page_url( array( 'wal_wallet_id' => $wal_wallet->get_id() ) ) ) ; ?>"><?php esc_html_e( 'View Transactions', 'wallet-for-woocommerce' ) ; ?></a>
		<ul class="wal-wallet-data-tabs">
			<?php foreach ( self::get_wallet_data_tabs() as $key => $panel_tab ) : ?>
				<li class="wal-wallet-data-tab <?php echo esc_attr( $key ) ; ?>_tab <?php echo esc_attr( isset( $panel_tab[ 'class' ] ) ? implode( ' ', ( array ) $panel_tab[ 'class' ] ) : ''  ) ; ?>">
					<a href="#<?php echo esc_attr( $panel_tab[ 'target' ] ) ; ?>" class="wal-wallet-data-tab-link">
						<span class="dashicons <?php echo esc_attr( $panel_tab[ 'icon_class' ] ) ; ?>"><?php echo esc_html( $panel_tab[ 'label' ] ) ; ?></span>
					</a>
				</li>
			<?php endforeach ; ?>
		</ul>

		<?php
		self::output_tabs() ;
		/**
		 * This hook is used to display the wallet data panels content.
		 * 
		 * @since 1.0
		 */
		do_action( 'wal_wallet_data_panels' ) ;
		?>
		<div class="clear"></div>

		<?php wp_nonce_field( 'wal_save_data', 'wal_meta_nonce' ) ; ?>
	</div>
</div>
<?php
