<?php
/**
 * Wallet General Panel.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ;
}
$wallet_details = wal_wallet_details_data( $wal_wallet ) ;
?>
<div id="wal_wallet_data_general" class="wal-wallet-options-wrapper wal-wallet-options-general woocommerce_options_panel">
	<div class="options_group">

		<?php
		if ( wal_check_is_array( $wallet_details ) ) :
			foreach ( $wallet_details as $key => $data ) :
				?>
				<p class="form-field wal-wallet-details-<?php echo esc_attr( str_replace( '_' , '-' , $key ) ) ; ?>">
					<label><?php echo esc_html( $data[ 'label' ] ) ; ?></label>
					<span><?php echo wp_kses_post( $data[ 'value' ] ) ; ?></span>
				</p>
				<?php
			endforeach ;
		endif ;
		?>

		<p class="form-field wal-wallet-details-expired-date">
			<label for="wal-expiry-day"><?php esc_html_e( 'Expires On' , 'wallet-for-woocommerce' ) ; ?></label>
			<?php
			$args = array(
				'default'      => '',
				'id'           => 'wal_wallet_expiry_day',
				'with_time'    => true,
				'convert_zone' => true,
				'placeholder'  => WAL_Date_Time::get_wp_date_format(),
				'value'        => ! empty( $wal_wallet->get_current_expiry_date() ) ? $wal_wallet->get_current_expiry_date() : '',
					) ;

			wal_get_datepicker_html( $args ) ;
			?>
		</p>
	</div>
</div>
<?php
