<?php
/**
 * User transaction logs page.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<div class="wal-user-transaction-logs-wrapper wrap">
	<h1>
		<?php esc_html_e( 'Transactions' , 'wallet-for-woocommerce' ) ; ?>
		<?php wc_back_link( '' , wal_get_wallet_page_url() ) ; ?>
		<a href="<?php echo esc_url( add_query_arg( array( 'post' => $wal_wallet->get_id(), 'action' => 'edit' ) , admin_url( 'post.php' ) ) ) ; ?>" class="page-title-action"><?php esc_html_e( 'Edit Wallet' , 'wallet-for-woocommerce' ) ; ?></a>
		<hr class="wp-header-end">
	</h1>
	<div class="wal-wallet-details">
		<p class="form-row">
			<label><?php esc_html_e( 'Username:' , 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( $wal_wallet->get_user_name() ) ; ?></span>
		</p>

		<p class="form-row">
			<label><?php esc_html_e( 'Available Balance:' , 'wallet-for-woocommerce' ) ; ?></label>
			<span><?php echo wp_kses_post( wal_price( $wal_wallet->get_balance() ) ) ; ?></span>
		</p>
	</div>
	<div class="wal-user-transaction-logs-content">
		<form method="POST" action="">
			<?php
			$post_table = new WAL_Transaction_Logs_List_Table() ;
			$post_table->render() ;
			?>
		</form>
	</div>
</div>
<?php


