<?php
/**
 * Top-up Bonus Amount.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>		
<table class="wal-topup-bonus-table" >
	<thead>
		<tr>
			<th><?php esc_html_e('Min Top-up Amount', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Max Top-up Amount', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Bonus Type', 'wallet-for-woocommerce'); ?></th>
			<th><?php esc_html_e('Bonus Value', 'wallet-for-woocommerce'); ?></th>
			<th colspan="5"><?php esc_html_e('Remove Level', 'wallet-for-woocommerce'); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if (wal_check_is_array($topup_bonus_rules)) :
			foreach ($topup_bonus_rules as $key => $rules) :
				$bonus_type = isset($rules['bonus_type']) ? $rules['bonus_type'] : 1;
				?>
				<tr class="wal-topup-bonus-row" >
					<td><input type="number" class="wal-min-topup-amount" step =".01" name="wal_general_topup_bonus_rules[<?php echo esc_attr($key); ?>][min_amount]" value="<?php echo esc_attr($rules['min_amount']); ?>"></td>
					<td><input type="number" class="wal-max-topup-amount" step =".01" name="wal_general_topup_bonus_rules[<?php echo esc_attr($key); ?>][max_amount]" value="<?php echo esc_attr($rules['max_amount']); ?>"></td>
					<td>
						<select name="wal_general_topup_bonus_rules[<?php echo esc_attr($key); ?>][bonus_type]">
							<option value="1" <?php selected('1', $bonus_type); ?>><?php esc_html_e('Fixed Amount', 'wallet-for-woocommerce'); ?></option>
							<option value="2" <?php selected('2', $bonus_type); ?>><?php esc_html_e('Percentage of Top-up Amount', 'wallet-for-woocommerce'); ?></option>
						</select>
					</td>
					<td><input type="number" class="wal-bonus-amount" step =".01" name="wal_general_topup_bonus_rules[<?php echo esc_attr($key); ?>][bonus_amount]" value="<?php echo esc_attr($rules['bonus_amount']); ?>"></td>
					<td>                        
						<input type="hidden" class="wal-remove-rule-id" value="<?php echo esc_attr($key); ?>" />
						<span class="dashicons dashicons-dismiss wal-remove-rule" title="<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>"></span>
					</td>
				</tr>  
				<?php
			endforeach;
		endif;
		?>
			
	</tbody>  
	<tfoot>
		<tr>
			<td colspan="5" class="wal-add-new-rule">
				<button type="button" class="wal-add-new-topup-bonus-rule">
					<?php esc_html_e('Add New Rule', 'wallet-for-woocommerce'); ?>
				</button>
			</td>
		</tr>
	</tfoot>
</table>  

<script type='text/html' id='tmpl-wal-add-topup-bonus-rule'>
	<tr class="wal-topup-bonus-row">
		<td>
			<input type ="number" class="wal-max-topup-amount" min="0" step =".01" name ="wal_general_topup_bonus_rules[{{data.group_id}}][min_amount]" 
				   min="0" value=""/>
		</td>
		<td>
			<input type ="number" class="wal-max-topup-amount" min="0" step =".01" name ="wal_general_topup_bonus_rules[{{data.group_id}}][max_amount]" 
				   min="0" value=""/>
		</td>
		<td>
			<select name="wal_general_topup_bonus_rules[{{data.group_id}}][bonus_type]">
				<option value="1"><?php esc_html_e('Fixed Amount', 'wallet-for-woocommerce'); ?></option>
				<option value="2"><?php esc_html_e('Percentage of Top-up Amount', 'wallet-for-woocommerce'); ?></option>                       
			</select>
		</td>
		<td>
			<input type ="number" class="wal-bonus-amount" min="0" step =".01" name ="wal_general_topup_bonus_rules[{{data.group_id}}][bonus_amount]" 
				   min="0" value=""/>
		</td>
		<td>
			<input type="hidden" class="wal-remove-rule-id" value="[{{data.group_id}}]" />
			<span class="dashicons dashicons-dismiss wal-remove-rule" title="<?php esc_attr_e('Remove', 'wallet-for-woocommerce'); ?>"></span>
		</td>           
	</tr> 
</script>
<?php


