<?php
/**
 * HTML - Simple product settings
 *
 * @var object $post
 * @since 3.1.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class='options_group show_if_simple'>
	<?php
	woocommerce_wp_select(
			array(
				'id' => '_wal_fund_type',
				'class' => 'wal-fund-type',
				'label' => __('Funds Type', 'wallet-for-woocommerce'),
				'default' => '1',
				'options' => array(                    
					'1' => __('Percentage of Product Price', 'wallet-for-woocommerce'),
					'2' => __('Fixed Value', 'wallet-for-woocommerce'),
				),
			)
	);
	woocommerce_wp_text_input(
			array(
				'id' => '_wal_fund_value',
				'class' => 'wc_input_price wal-fund-value',
				'name' => '_wal_fund_value',
				'desc_tip' => 'true',
				'description' => __('Enter the valid Number', 'wallet-for-woocommerce'),
				'label' => __('Enter the value', 'wallet-for-woocommerce'),
				'value' => get_post_meta($post->ID, '_wal_fund_value', true),
			)
	);
	woocommerce_wp_checkbox(
			array(
				'id' => '_wal_block_fund',
				'class' => 'wal-block-fund',
				'label' => __('Block Product Purchase Funds', 'wallet-for-woocommerce'),
				'value' => get_post_meta($post->ID, '_wal_block_fund', true),
			)
	);
	?>
</div>
<?php
