<?php
/**
 * Shortcodes information.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
?>
<table class="form-table wal_shortcodes_info widefat striped">
	<thead>
		<tr>
			<th><?php esc_html_e( 'Shortcode', 'wallet-for-woocommerce' ) ; ?></th>
			<th><?php esc_html_e( 'Parameter Support', 'wallet-for-woocommerce' ) ; ?></th>
			<th><?php esc_html_e( 'Description', 'wallet-for-woocommerce' ) ; ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if ( wal_check_is_array( $shortcodes_info ) ) :
			foreach ( $shortcodes_info as $shortcode => $details ) :
				?>
				<tr>
					<td><?php echo esc_html( $shortcode ) ; ?></td>
					<td><?php echo esc_html( $details[ 'supported_parameters' ] ) ; ?></td>
					<td><?php echo esc_html( $details[ 'usage' ] ) ; ?></td>
				</tr>
				<?php
			endforeach ;
		endif ;
		?>
	</tbody>
</table>
<?php

