<?php
/**
 * Redeem Wallet Funds Popup.
 *
 * @since 3.4.0
 * @var int $order_id
 * @var int $user_id 
 * */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>

<div class='wal-redeem-wallet-funds-popup-wrapper'>
	<h1>
		<?php
		/* translators: %s - ID */
		echo wp_kses_post(sprintf(__('Order ID - #%s', 'wallet-for-woocommerce'), $order_id));
		?>
	</h1>
	<div class='wal-user-info'>
		<h2>
			<?php
			/* translators: %s - User name */
			echo wp_kses_post(sprintf(__('User Name - %s', 'wallet-for-woocommerce'), get_userdata($user_id)->display_name));
			?>
		</h2>
	</div>
	<div class='wal-wallet-balance-details'>
		<h3>
			<?php
			/* translators: %s - Wallet Balance */
			echo wp_kses_post(sprintf(__('Wallet Balance - %s', 'wallet-for-woocommerce'), wal_convert_price_by_currency($wallet->get_balance())));
			?>
		</h3>
	</div>
	<div class='wal-partial-fund-usage-content'>
		<label><?php echo wp_kses_post(__('Redeem Your Wallet Funds', 'wallet-for-woocommerce')); ?></label>
		<input type='text' 
			   class='wal-number-field wal-partial-fund-usage-amount wc_input_price'
			   placeholder='<?php echo esc_attr(wal_get_partial_usage_placeholder_label()); ?>'/>
				<button type='button' class='button button-primary wal-partial-fund-usage-btn'><?php echo wp_kses_post(wal_get_partial_usage_button_label()); ?></button>
	</div>
</div>
<?php
