<?php
/**
 * HTML - Product variation settings
 *
 * @var int variation_id
 * @var int $loop
 * @since 3.1.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class='wal-product-purchase-funds-variation show_if_variable'>
	<?php
	woocommerce_wp_select(
			array(
				'id' => '_wal_fund_type[' . $loop . ']',
				'label' => __('Funds Type', 'wallet-for-woocommerce'),                
				'class' => 'wal-fund-type short',
				'value' => get_post_meta($variation_id, '_wal_fund_type', true),
				'default' => '1',
				'options' => array(
					'1' => __('Percentage of ProductPrice', 'wallet-for-woocommerce'),
					'2' => __('Fixed Value', 'wallet-for-woocommerce'),
				),
			)
	);

	woocommerce_wp_text_input(
			array(
				'id' => '_wal_fund_value[' . $loop . ']',
				'label' => __('Enter the value', 'wallet-for-woocommerce'),
				'class' => 'wc_input_price wal-fund-value short',
				'value' => get_post_meta($variation_id, '_wal_fund_value', true),
			)
	);

	woocommerce_wp_checkbox(
			array(
				'id' => '_wal_block_fund[' . $loop . ']',
				'class' => 'wal-block-fund short',
				'label' => __('Block Fund for this Product', 'wallet-for-woocommerce'),
				'value' => get_post_meta($variation_id, '_wal_block_fund', true),
			)
	);
	?>
</div>
<?php
