<?php
/**
 * Modules Table.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
global $current_module, $current_tab ;
?>
<div class="wal-wallet-modules-wrapper woocommerce">

	<form method = "post" enctype = "multipart/form-data" class="wal-wallet-modules-form">
		<div class="wal-wallet-modules-content">
			<?php if ( ! $current_module ) : ?>
				<h1><?php esc_html_e( 'Modules', 'wallet-for-woocommerce' ) ; ?></h1>
				<table class="wal-modules-table widefat striped">
					<thead>
						<tr>
							<?php
							/**
							 * This hook is used to alert the wallet modules column.
							 * 
							 * @since 1.0
							 */
							$columns = apply_filters( 'wal_wallet_modules_cloumn', array(
							'status'      => __( 'Enable/Disable', 'wallet-for-woocommerce' ),
								'name'        => __( 'Module', 'wallet-for-woocommerce' ),
								'description' => __( 'Description', 'wallet-for-woocommerce' ),
								'actions'     => __( 'Actions', 'wallet-for-woocommerce' ),
									) ) ;

							foreach ( $columns as $key => $column ) :
								echo '<th class="wal-module-settings-table-' . esc_attr( $key ) . '">' . esc_html( $column ) . '</th>' ;
							endforeach ;
							?>
						</tr>
					</thead>
					<tbody>
						<?php
						foreach ( WAL_Module_Instances::get_modules() as $key => $module ) :
							?>
							<tr>
								<?php foreach ( $columns as $cloumn_key => $label ) : ?>
									<?php
									switch ( $cloumn_key ) :
										case 'status':
											?>
											<td data-title="<?php echo esc_attr( $label ) ; ?>">
												<input type="checkbox" class="wal-enable-module" name="<?php echo esc_attr( $module->get_enable_key() ) ; ?>" data-module="<?php echo esc_attr( $key ) ; ?>" <?php checked( true, $module->is_enabled() ) ; ?>/>
											</td>
											<?php
											break ;
										case 'name':
											?>
											<td data-title="<?php echo esc_attr( $label ) ; ?>">
												<a href="<?php echo esc_url( wal_get_module_page_url( array( 'module' => $key ) ) ) ; ?>"><?php echo esc_html( $module->get_title() ) ; ?></a>
											</td>
											<?php
											break ;
										case 'description':
											?>
											<td data-title="<?php echo esc_attr( $label ) ; ?>">
												<?php echo wp_kses_post( $module->get_description() ) ; ?>
											</td>
											<?php
											break ;
										case 'actions':
											?>
											<td data-title="<?php echo esc_attr( $label ) ; ?>">
												<a href="<?php echo esc_url( wal_get_module_page_url( array( 'module' => $key ) ) ) ; ?>" class="button">
													<?php esc_html_e( 'Manage', 'wallet-for-woocommerce' ) ; ?>
												</a>
											</td>
											<?php
											break ;
										default:
											/**
											 * This hook is used to display the wallet modules custom column content.
											 * 
											 * @since 1.0
											 */
											do_action( 'wal_wallet_modules_' . $key, $module ) ;
											break ;
									endswitch ;
								endforeach ;
								?>
							</tr>
							<?php
						endforeach ;
						?>
					</tbody>
				</table>
			<?php else : ?>
				<div class = "wal-wallet-module-settings-wrapper">
					<h2>
						<?php echo esc_html( __( 'Module - ', 'wallet-for-woocommerce' ) . WAL_Module_Instances::get_module_by_id( $current_module )->get_title() ) ; ?>
						<?php wc_back_link( '', wal_get_module_page_url() ) ; ?>
					</h2>
					<p class="wal-module-global-enable-field-wrapper">
						<label for="wal_module_enabled"><?php esc_html_e( 'Enable/Disable', 'wallet-for-woocommerce' ) ; ?></label>
						<input type="checkbox" class="wal-enable-module" 
							   name="<?php echo esc_attr( WAL_Module_Instances::get_module_by_id( $current_module )->get_enable_key() ) ; ?>"
							   data-module="<?php echo esc_attr( $current_module ) ; ?>" value="yes" 
							   <?php checked( WAL_Module_Instances::get_module_by_id( $current_module )->is_enabled(), true, true ) ; ?>/>
							   <?php echo wp_kses_post( WAL_Module_Instances::get_module_by_id( $current_module )->get_tooltip() ) ; ?>

					</p>
					<?php
					$setting_tabs = WAL_Module_Instances::get_module_by_id( $current_module )->setting_tabs() ;
					if ( wal_check_is_array( $setting_tabs ) ) :
						?>
						<nav class = "nav-tab-wrapper woo-nav-tab-wrapper wal-module-tabs">
							<?php foreach ( $setting_tabs as $name => $label ) { ?>
								<a href="<?php echo esc_url( wal_get_module_page_url( array( 'module' => $current_module, 'tab' => $name ) ) ) ; ?>" class="nav-tab wal_tab_a <?php echo esc_attr( $name ) . '_a ' . ( $current_tab == $name ? 'nav-tab-active' : '' ) ; ?>">
									<span><?php echo esc_html( $label ) ; ?></span>
								</a>
							<?php } ?>
						</nav>
					<?php endif ; ?>

					<div class="wal-wallet-module-settings-content wal-wallet-module-settings-content-<?php echo esc_attr( $current_module ) ; ?>">
						<div class="wal-module-settings-inner_content wal_module_setting_inner_content-<?php echo esc_attr( $current_module ) ; ?>">

							<?php
							/**
							 * This hook is used to display the settings content.
							 * 
							 * @hooked WAL_Settings::show_messages - 5 (messages)
							 * @since 1.0
							 */
							do_action( 'wal_settings_content' ) ;
							?>

							<?php
							/**
							 * This hook is used to display the current module settings content.
							 * 
							 * @hooked WAL_Modules::output_settings - 10 (messages)
							 * @hooked WAL_Modules::output_setting_buttons - 5 (messages)
							 * @since 1.0
							 */
							do_action( sanitize_key( 'wal_module_settings_' . $current_module ) ) ;
							?>
						</div>
					</div>
				</div>
			<?php endif ; ?>
		</div>
	</form>
</div>
<?php
