<?php
/**
 * Credit debit funds page.
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
?>
<div class="wal-credit-debit-funds-wrapper">
	<h1><?php esc_html_e('Credit/Debit Funds', 'wallet-for-woocommerce'); ?></h1>
	<div class="wal-credit-debit-funds-content">
		<p class="form-row">
			<label for="wal-credit-debit-user-type"><?php esc_html_e('User Selection', 'wallet-for-woocommerce'); ?></label>
			<select class="wal-credit-debit-user-type">
				<option value="1"><?php esc_html_e('All Users', 'wallet-for-woocommerce'); ?></option>
				<option value="2"><?php esc_html_e('Include Users', 'wallet-for-woocommerce'); ?></option>
				<option value="3"><?php esc_html_e('Exclude Users', 'wallet-for-woocommerce'); ?></option>
				<option value="4"><?php esc_html_e('Include User Roles', 'wallet-for-woocommerce'); ?></option>
				<option value="5"><?php esc_html_e('Exclude User Roles', 'wallet-for-woocommerce'); ?></option>
			</select>
		</p>

		<p class="form-row">
			<label for="wal-credit-debit-user"><?php esc_html_e('Select the User', 'wallet-for-woocommerce'); ?><span>*</span></label>
			<?php
			$args = array(
				'id' => 'wal-credit-debit-users',
				'list_type' => 'customers',
				'class' => 'wal-credit-debit-users wal-credit-debit-user-type-field',
				'action' => 'wal_json_search_customers',
				'multiple' => true,
				'placeholder' => __('Select the User', 'wallet-for-woocommerce'),
			);
			wal_select2_html($args);
			?>
		</p>
		<p class="form-row">
			<label for="wal-credit-debit-user-roles"><?php esc_html_e('Select the User Roles', 'wallet-for-woocommerce'); ?></label>
			<select class="wal-credit-debit-user-roles wal_select2 wal-credit-debit-user-type-field" multiple="multiple" data-placeholder="<?php echo esc_attr__('Select the User Roles', 'wallet-for-woocommerce'); ?>">
				<?php foreach (wal_get_wp_user_roles() as $key => $label) : ?>
					<option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($label); ?></option>
				<?php endforeach; ?>
			</select>
		</p>

		<p class="form-row">
			<label for="wal-credit-debit-type"><?php esc_html_e('Credit/Debit', 'wallet-for-woocommerce'); ?></label>
			<select class="wal-credit-debit-type">
				<option value="1"><?php esc_html_e('Credit', 'wallet-for-woocommerce'); ?></option>
				<option value="2"><?php esc_html_e('Debit', 'wallet-for-woocommerce'); ?></option>
			</select>
		</p>

		<p class="form-row">
			<label for="wal-credit-debit-fund"><?php esc_html_e('Enter the Value', 'wallet-for-woocommerce'); ?><span>*</span></label>
			<input type="text" class="wc_input_price wal-credit-debit-fund" placeholder="<?php esc_attr_e('Enter some funds', 'wallet-for-woocommerce'); ?>" />
		</p>

		<p class="form-row">
			<label for="wal-credit-debit-reason"><?php esc_html_e('Reason', 'wallet-for-woocommerce'); ?></label>
			<textarea class="wal-credit-debit-reason" rows="5" placeholder="<?php esc_attr_e('Enter a reason', 'wallet-for-woocommerce'); ?>"></textarea>
		</p>

		<p class="form-row">
			<button type="button" class="wal-credit-debit-action button button-primary"><?php esc_html_e('Update', 'wallet-for-woocommerce'); ?></button>
		</p>
	</div>
</div>
<?php


