<?php
/**
 * HTML - Edit category level settings
 * 
 * @var int $fund_type
 * @var float $fund_value
 * @var string $block_fund
 * @var string $checked
 * 
 * @since 3.1.0
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$fund_type = get_term_meta($term->term_id, '_wal_fund_type', true);
$fund_value = get_term_meta($term->term_id, '_wal_fund_value', true);
$block_fund = get_term_meta($term->term_id, '_wal_block_fund', true);
$checked = ( 'on' === $block_fund ) ? 'checked="checked"' : '';
?>
<tr class='form-field'>
	<th scope='row' valign='top'><label> <?php esc_html_e('Funds Type', 'wallet-for-woocommerce'); ?></label></th>
	<td>
		<select name='_wal_fund_type'>
			<option value="1"<?php selected('1', $fund_type); ?>><?php esc_html_e('Percentage Product Price', 'wallet-for-woocommerce'); ?></option>
			<option value="2"<?php selected('2', $fund_type); ?>><?php esc_html_e('Fixed Value', 'wallet-for-woocommerce'); ?></option>
		</select>		
	</td>
</tr>

<tr class='form-field'>
	<th scope='row' valign='top'><label><?php esc_html_e('Enter the value', 'wallet-for-woocommerce'); ?></label></th>
	<td>        
		<input type='text' name='_wal_fund_value' class='wc_input_price' value='<?php echo floatval($fund_value); ?>'/>	
	</td>
</tr>

<tr class='form-field'>
	<th scope='row' valign='top'><label><?php esc_html_e('Block Fund for this Category', 'wallet-for-woocommerce'); ?></label></th>
	<td>
		<input type='checkbox' name='_wal_block_fund'
			   <?php echo esc_attr($checked); ?> />
	</td>
</tr>
<?php
