<?php

/**
 * Shortcodes Tab.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'WAL_Shortcode_Tab' ) ) {
	return new WAL_Shortcode_Tab() ;
}

/**
 * Class.
 * */
class WAL_Shortcode_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 * */
	public function __construct() {

		$this->id           = 'shortcodes' ;
		$this->label        = __( 'Shortcodes' , 'wallet-for-woocommerce' ) ;
		$this->show_buttons = false ;

		//Display the shortcode information.
		add_action( 'woocommerce_admin_field_wal_shortcodes_information' , array( $this, 'shortcodes_information' ) ) ;

		parent::__construct() ;
	}

	/**
	 * Get the settings for shortcodes section array.
	 * 
	 * @return array
	 * */
	protected function shortcodes_section_array() {

		$section_fields = array() ;

		// Shortcodes section start.
		$section_fields[] = array(
			'type'  => 'title',
			'title' => __( 'Shortcodes' , 'wallet-for-woocommerce' ),
			'id'    => 'wal_shortcodes_options',
				) ;
		$section_fields[] = array(
			'type' => 'wal_shortcodes_information',
				) ;
		$section_fields[] = array(
			'type' => 'sectionend',
			'id'   => 'wal_shortcodes_options',
				) ;
		// Shortcodes section end.

		return $section_fields ;
	}

	/**
	 * Display the shortcode information.
	 * 
	 * @retrun void
	 * */
	public function shortcodes_information() {

		$shortcodes_info = array(
			'[wal_dashboard]'            => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Wallet Dashboard' , 'wallet-for-woocommerce' ),
			),
			'[wal_topup_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Wallet Top-up Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_transaction_details]'  => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Overall Wallet Transaction Details' , 'wallet-for-woocommerce' ),
			),
			'[wal_overview]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Wallet Overview' , 'wallet-for-woocommerce' ),
			),
			'[wal_fund_transaction_log]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Transaction Log for Fund Transfer & Request' , 'wallet-for-woocommerce' ),
			),
			'[wal_fund_transfer_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Fund Transfer Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_fund_request_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Fund Request Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_auto_topup_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Auto Top-up Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_voucher_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Voucher Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_withdraw_transaction_log]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Withdraw Transaction Log' , 'wallet-for-woocommerce' ),
			),
			'[wal_withdraw_request_form]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Withdraw Request Form' , 'wallet-for-woocommerce' ),
			),
			'[wal_available_balance]'    => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Available Wallet Balance' , 'wallet-for-woocommerce' ),
			),
			'[wal_total_usage]'          => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Total Wallet Amount Spent on the Site' , 'wallet-for-woocommerce' ),
			),
			'[wal_total_topup_amount]'   => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Total Top-up Amount' , 'wallet-for-woocommerce' ),
			),
			'[wal_total_expired_amount]' => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Total Expired Amount' , 'wallet-for-woocommerce' ),
			),
			'[wal_status]'               => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Wallet Status' , 'wallet-for-woocommerce' ),
			),
			'[wal_expiry_date]'          => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Wallet Expiry Date' , 'wallet-for-woocommerce' ),
			),
			'[wal_user_name]'            => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Username' , 'wallet-for-woocommerce' ),
			),
			'[wal_user_email]'           => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the Email ID of the User' , 'wallet-for-woocommerce' ),
			),
			'[wal_user_avatar]'          => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the User Avatar' , 'wallet-for-woocommerce' ),
			),
			'[wal_credit_debit_reason]'          => array(
				'supported_parameters' => 'No',
				'usage'                => __( 'Displays the reason given when manually crediting/debiting the funds' , 'wallet-for-woocommerce' ),
			),
				) ;

		include_once WAL_ABSPATH . 'inc/admin/menu/views/html-shortcodes-info.php'  ;
	}
}

return new WAL_Shortcode_Tab() ;
