<?php
/**
 * Reset tab
 *
 * @since 3.5.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( class_exists( 'WAL_Reset_Tab' ) ) {
	return new WAL_Reset_Tab();
}

/**
 * Class.
 *
 * @since 3.5.0
 */
class WAL_Reset_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 *
	 * @since 3.5.0
	 */
	public function __construct() {
		$this->id           = 'reset';
		$this->show_buttons = false;
		$this->label        = __( 'Reset', 'wallet-for-woocommerce' );

		parent::__construct();
	}

	/**
	 * Get settings for reset section array.
	 *
	 * @since 3.5.0
	 * @return array
	 */
	public function reset_section_array() {
		$section_fields = array();
		$wp_user_roles  = wal_get_wp_user_roles();

		// Reset section start.
		$section_fields[] = array(
			'type'  => 'title',
			'title' => __( 'Reset Settings', 'wallet-for-woocommerce' ),
			'id'    => 'wal_reset_options',
		);
		$section_fields[] = array(
			'title'    => __( 'User(s)/User Role(s) Selection:', 'wallet-for-woocommerce' ),
			'type'     => 'select',
			'default'  => '1',
			'autoload' => false,
			'id'       => $this->get_option_key( 'user_selection_type' ),
			'class'    => 'wal-user-selection-type',
			'options'  => array(
				'1' => __( 'All Users', 'wallet-for-woocommerce' ),
				'2' => __( 'Include User(s)', 'wallet-for-woocommerce' ),
				'3' => __( 'Exclude User(s)', 'wallet-for-woocommerce' ),
				'4' => __( 'Include User Role(s)', 'wallet-for-woocommerce' ),
				'5' => __( 'Exclude User Role(s)', 'wallet-for-woocommerce' ),
			),
		);
		$section_fields[] = array(
			'title'       => __( 'Select the User(s) to Include', 'wallet-for-woocommerce' ),
			'type'        => 'wal_custom_fields',
			'wal_field'   => 'ajaxmultiselect',
			'list_type'   => 'customers',
			'action'      => 'wal_json_search_customers',
			'default'     => array(),
			'autoload'    => false,
			'placeholder' => __( 'Select a User', 'wallet-for-woocommerce' ),
			'class'       => 'wal-user-selection-field wal-reset-include-users-field',
			'id'          => $this->get_option_key( 'include_users' ),
		);
		$section_fields[] = array(
			'title'       => __( 'Select the User(s) to Exclude', 'wallet-for-woocommerce' ),
			'type'        => 'wal_custom_fields',
			'wal_field'   => 'ajaxmultiselect',
			'list_type'   => 'customers',
			'class'       => 'wal-user-selection-field wal-reset-exclude-users-field',
			'action'      => 'wal_json_search_customers',
			'default'     => array(),
			'autoload'    => false,
			'placeholder' => __( 'Select a User', 'wallet-for-woocommerce' ),
			'id'          => $this->get_option_key( 'exclude_users' ),
		);
		$section_fields[] = array(
			'title'             => __( 'Select the User Role(s) to Include', 'wallet-for-woocommerce' ),
			'type'              => 'multiselect',
			'default'           => array(),
			'autoload'          => false,
			'custom_attributes' => array( 'placeholder' => __( 'Select a User Role', 'wallet-for-woocommerce' ) ),
			'class'             => 'wal_select2 wal-user-selection-field wal-reset-include-user-roles-field',
			'id'                => $this->get_option_key( 'include_user_roles' ),
			'options'           => $wp_user_roles,
		);
		$section_fields[] = array(
			'title'             => __( 'Select the User Role(s) to Exclude', 'wallet-for-woocommerce' ),
			'type'              => 'multiselect',
			'default'           => array(),
			'autoload'          => false,
			'custom_attributes' => array( 'placeholder' => __( 'Select a User Role', 'wallet-for-woocommerce' ) ),
			'class'             => 'wal_select2 wal-user-selection-field wal-reset-exclude-user-roles-field',
			'id'                => $this->get_option_key( 'exclude_user_roles' ),
			'options'           => $wp_user_roles,
		);
		$section_fields[] = array(
			'title'   => __( 'Reset Wallet Balance', 'wallet-for-woocommerce' ),
			'type'    => 'checkbox',
			'default' => 'no',
			'id'      => $this->get_option_key( 'wallet_balance' ),
		);
		$section_fields[] = array(
			'title'   => __( 'Reset Transaction Log', 'wallet-for-woocommerce' ),
			'type'    => 'checkbox',
			'default' => 'no',
			'id'      => $this->get_option_key( 'transaction_log' ),
		);
		$section_fields[] = array(
			'type'      => 'wal_custom_fields',
			'wal_field' => 'button',
			'default'   => 'Reset',
			'class'     => 'button-primary wal-reset-user-wallet-data',
			'id'        => $this->get_option_key( 'user_data' ),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id'   => 'wal_reset_options',
		);
		// Reset section end.

		return $section_fields;
	}
}

return new WAL_Reset_Tab();
