<?php

/**
 * Notification Tab.
 * */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (class_exists('WAL_Notification_Tab')) {
	return new WAL_Notification_Tab();
}

/**
 * Class.
 * */
class WAL_Notification_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 * */
	public function __construct() {
		$this->id = 'notifications';
		$this->label = __('Notifications', 'wallet-for-woocommerce');

		// Save the notification settings.
		add_action(sanitize_key($this->plugin_slug . '_after_' . $this->id . '_settings_saved'), array( $this, 'save_notification_settings' ));
		// Reset the notification settings.
		add_action(sanitize_key($this->plugin_slug . '_after_' . $this->id . '_settings_reset'), array( $this, 'reset_notification_settings' ));

		parent::__construct();
	}

	/**
	 * Get the settings for notifications section array.
	 * 
	 * @return array
	 * */
	protected function notifications_section_array() {
		global $current_section;

		// Email settings section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Email Settings', 'wallet-for-woocommerce'),
			'id' => 'wal_email_options',
		);
		$section_fields[] = array(
			'title' => __('Email Type', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('email_template_type'),
			'type' => 'select',
			'default' => '2',
			'autoload' => false,
			'options' => array(
				'1' => __('HTML', 'wallet-for-woocommerce'),
				'2' => __('WooCommerce Template', 'wallet-for-woocommerce'),
			),
		);
		$section_fields[] = array(
			'title' => __('From Name', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('email_from_name'),
			'type' => 'text',
			'default' => get_option('woocommerce_email_from_name'),
			'autoload' => false,
		);
		$section_fields[] = array(
			'title' => __('From Address', 'wallet-for-woocommerce'),
			'id' => $this->get_option_key('email_from_address'),
			'type' => 'text',
			'default' => get_option('woocommerce_email_from_address'),
			'autoload' => false,
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_email_options',
		);
		// Email settings section end.

		return $section_fields;
	}

	/**
	 * Output the notifications.
	 * */
	public function output() {
		global $current_section;

		if (!$current_section) {
			return;
		}

		if ('notifications' == $current_section) {
			include_once WAL_ABSPATH . 'inc/admin/menu/views/html-notifications.php' ;
			parent::output();
		} else {
			$notification = WAL_Notification_Instances::get_notification_by_id($current_section);
			if (!is_object($notification)) {
				return;
			}

			$notification->output();
		}
	}

	/**
	 * Save the notification settings.
	 */
	public function save_notification_settings() {
		global $current_section;

		if ('notifications' != $current_section) {
			$notification = WAL_Notification_Instances::get_notification_by_id($current_section);
			if (!$notification) {
				return;
			}

			$notification->save();
		} else {
			$notifications = WAL_Notification_Instances::get_notifications();
			foreach ($notifications as $notification) {
				// Enable/ Disable the Notifications.
				$value = ( isset($_REQUEST[$notification->get_option_key('enabled')]) ) ? 'yes' : 'no';

				update_option($notification->get_option_key('enabled'), $value);
			}

			WAL_Notification_Instances::reset();
		}
	}

	/**
	 * Reset the notifications settings.
	 */
	public function reset_notification_settings() {
		global $current_section;

		if ('notifications' != $current_section) {
			$notification = WAL_Notification_Instances::get_notification_by_id($current_section);
			if (!$notification) {
				return;
			}

			$notification->reset();
		} else {
			$notifications = WAL_Notification_Instances::get_notifications();
			foreach ($notifications as $notification) {
				// Disable Emailsvif notification is enabled.
				if ($notification->is_enabled()) {
					update_option($notification->get_option_key('enabled'), '');
				}
			}

			WAL_Notification_Instances::reset();
		}
	}
}

return new WAL_Notification_Tab();
