<?php

/**
 * Messages Tab
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (class_exists('WAL_Messages_Tab')) {
	return new WAL_Messages_Tab();
}

/**
 * Class.
 */
class WAL_Messages_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id = 'messages';
		$this->label = __('Messages', 'wallet-for-woocommerce');

		parent::__construct();
	}

	/**
	 * Get the sections.
	 * 
	 * @return array
	 */
	public function get_sections() {
		$sections = array(
			'general' => __('General', 'wallet-for-woocommerce'),
			'topup' => __('Funds Top-up', 'wallet-for-woocommerce'),
			'fund_usage' => __('Funds Usage', 'wallet-for-woocommerce'),
		);
		/**
		 * This hook is used to alter the message tab sections.
		 * 
		 * @since 1.0
		 */
		return apply_filters($this->get_plugin_slug() . '_get_sections_' . $this->get_id(), $sections);
	}

	/**
	 * Get the settings for general messages section array.
	 * 
	 * @return array
	 */
	protected function general_section_array() {
		$section_fields = array();

		// General messages section start
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('General Messages', 'wallet-for-woocommerce'),
			'id' => 'wal_general_messages_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Disabled Message', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Currently, your wallet account has been disabled. Please contact the site admin to get more details.',
			'autoload' => false,
			'id' => $this->get_option_key('admin_wallet_inactive'),
		);
		$section_fields[] = array(
			'title' => __('Guest Login Message', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please {login} to view the content.',
			'autoload' => false,
			'id' => $this->get_option_key('shortcode_guest_login'),
			'desc' => __('<b>{login}</b> - It will redirect to the My Account page,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Guest Login Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'login',
			'autoload' => false,
			'id' => $this->get_option_key('shortcode_guest_login_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_general_messages_options',
		);
		// General messages section end

		return $section_fields;
	}

	/**
	 * Get the settings for top up messages section array.
	 * 
	 * @return array
	 */
	protected function topup_section_array() {
		$section_fields = array();

		// Top up messages section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Funds Top-up Messages', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_messages_options',
		);
		$section_fields[] = array(
			'title' => __("Message to Display when a User didn't Enter the Funds", 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter the funds',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_fund_empty'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User enters Alphabets', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter a numeric value',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_fund_numeric'),
		);
		$section_fields[] = array(
			'title' => __('Minimum Amount Required for Wallet Top-up', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter an amount more than {topup_min_amount}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_minimum_amount'),
			'desc' => __('<b>{topup_min_amount}</b> - It will display the minimum topup amount value required,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Maximum Amount that can be recharged to Wallet through Top-up', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter an amount less than {topup_max_amount}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_amount'),
			'desc' => __('<b>{topup_max_amount}</b> - It will display the maximum topup amount value required,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User has reached the Maximum Wallet Balance Threshold', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You cannot Top-up your Wallet because you have reached the Maximum Threshold of {max_threshold_value}. Try using the available funds before proceeding to Top-up.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_wallet_amount'),
			'desc' => __('<b>{max_threshold_value}</b> - It will display the maximum threshold value reached,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the Maximum Number of Top-up Per Day', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You are allowed to Top-up a Maximum of {topup_count} time(s) per day. Since you have reached the count, you cannot do anymore top-ups today.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_count_per_day'),
			'desc' => __('<b>{topup_count}</b> - It will display the maximum topup count reached per day,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the Maximum Top-up Amount Per Day', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You are allowed to top-up a Maximum of {topup_amount} per day. Since you have already added the {top-up_amount} amount to your wallet, you cannot do anymore top-ups today.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_amount_per_day'),
			'desc' => __('<b>{topup_amount}</b> - It will display the maximum topup amount reached per day,</br><b>{top-up_amount}</b> - It will display the maximum topup amount reached per day,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __("Message to display when the Site Admin has disabled the User's Wallet", 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Currently, your wallet has been disabled. Hence, you are unable to Top-up your Wallet.',
			'autoload' => false,
			'id' => $this->get_option_key('topup_wallet_disabled'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when the User(s)/User Role(s) is Restricted', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You have restricted to Top-up your Wallet',
			'autoload' => false,
			'id' => $this->get_option_key('topup_wallet_restricted'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to Top-up more than the Maximum Wallet Threshold Value', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Maximum Amount to hold on your Wallet is {max_threshold_value}. Hence, try to Top-up below the Threshold Value.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_wallet_amount_error'),
			'desc' => __('<b>{max_threshold_value}</b> - It will display the maximum threshold value when a user tries to enter more than the configured value,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to Top-up more than the Restricted Amount Per Day', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Maximum Top-up Amount allowed Per Day is {topup_amount}. Your available Top-up amount today is {topup_balance_amount}.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_maximum_amount_per_day_error'),
			'desc' => __('<b>{topup_amount}</b> - It will display the maximum topup amount when a user tries to enter more than the configured value,</br><b>{topup_balance_amount}</b> - It will display the balance amount value to top-up for the day,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to perform Top-up & Purchases at the Same Time', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You cannot add other products when top-up product in the cart.',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_validate_other_product_cart'),
		);
		$section_fields[] = array(
			'title' => __('WooCommerce Coupon Redeeming Error Message', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Coupon Usage is restricted for Top-up Purchase',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_product_coupon_discount_restriction'),
		);
		$section_fields[] = array(
			'title' => __('Error Notice for Top-up Incrementor', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter the values in multiples of {incrementor_value}',
			'autoload' => false,
			'id' => $this->get_option_key('error_notice_for_topup_incrementor'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_messages_options',
		);
		// Top up messages section end.

		return $section_fields;
	}

	/**
	 * Get the settings for fund usage messages section array.
	 * 
	 * @return array
	 */
	protected function fund_usage_section_array() {
		$section_fields = array();

		// Fund usage messages section start
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Funds Usage Messages', 'wallet-for-woocommerce'),
			'id' => 'wal_fund_usage_messages_options',
		);
		$section_fields[] = array(
			'title' => __("Message to Display when a User didn't Enter the Funds", 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter the funds',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_empty'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User enters Alphabets', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter a numeric value',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_numeric'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when the User(s)/User Role(s) is Restricted', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You are restricted from using the Wallet Funds',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_user_restricted'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to Redeem more than the Restricted Funds', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Please enter less than {restricted_funds}',
			'autoload' => false,
			'id' => $this->get_option_key('partial_allow_maximum_fund'),
			'desc' => __('<b>{restricted_funds}</b> - It will display the restricted funds value configured in the settings,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to Redeem more than the Available Funds', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'You have entered more than your available wallet balance. Please enter less than {wallet_balance}.',
			'autoload' => false,
			'id' => $this->get_option_key('partial_wallet_insufficient_fund'),
			'desc' => __('<b>{wallet_balance}</b> - It will display the current wallet balance,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when Funds Redeemed in Cart/Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds Redeemed Successfully.',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_added'),
		);       
		$section_fields[] = array(
			'title' => __('Message to display when Funds Removed in Cart/Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds Removed Successfully.',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_removed'),
		);
		$section_fields[] = array(
			'title' => __('Available Wallet Funds Label in Cart & Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Available Wallet Funds: {balance}',
			'autoload' => false,
			'id' => $this->get_option_key('partial_usage_balance'),
			'desc' => __('<b>{balance}</b> - It will display the available wallet balance,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a User tries to Redeem more than the Restricted Funds in Cart & Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Maximum fund can be redeemed in this order is {max_redeem_funds}',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_usage_limit'),
			'desc' => __('<b>{max_redeem_funds}</b> - It will display the maximum number of wallet funds that can be redeemed in the order,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the usage restriction per day[Number of Times - Partial Payments]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => "Since you have reached the fund's usage limit count, you cannot redeem your funds anymore today.",
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_usage_limit_count'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the usage restriction per day[Number of Times - Wallet Gateway]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => "Since you have reached the fund's usage limit count, you cannot use the wallet gateway anymore today.",
			'autoload' => false,
			'id' => $this->get_option_key('wallet_gateway_usage_limit_count'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the usage restriction per day[Funds Spent - Partial Payments]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => "Since you have reached the fund's usage spent value, you cannot redeem your funds anymore today.",
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_usage_spent_value'),
		);
		$section_fields[] = array(
			'title' => __('Message to display when a user has reached the usage restriction per day[Funds Spent - Wallet Gateway]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => "Since you have reached the fund's usage spent value, you cannot use the wallet gateway anymore today.",
			'autoload' => false,
			'id' => $this->get_option_key('wallet_usage_spent_value'),
		);
		$section_fields[] = array(
			'title' => __('Fund Usage Error Message', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Fund Usage is not applicable to the selected product(s).',
			'autoload' => false,
			'id' => $this->get_option_key('product_filter_error_for_usage'),
		);
		$section_fields[] = array(
			'title' => __('Success Message for Discount', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Discount Applied Successfully.',
			'autoload' => false,
			'id' => $this->get_option_key('success_msg_for_discount'),
		);
		$section_fields[] = array(
			'title' => __('Notice for Discount in Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Get Discount of {discount_value} by using Wallet Gateway.',
			'autoload' => false,
			'id' => $this->get_option_key('notice_for_discount'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_fund_usage_messages_options',
		);
		// Fund usage messages section end

		return $section_fields;
	}
}

return new WAL_Messages_Tab();
