<?php

/**
 * Localization Tab
 */
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

if (class_exists('WAL_Localization_Tab')) {
	return new WAL_Localization_Tab();
}

/**
 * Class.
 */
class WAL_Localization_Tab extends WAL_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id = 'localization';
		$this->label = __('Localization', 'wallet-for-woocommerce');

		parent::__construct();
	}

	/**
	 * Get the sections.
	 * 
	 * @return array
	 */
	public function get_sections() {
		$sections = array(
			'general' => __('Top-up Form', 'wallet-for-woocommerce'),
			'fund_usage' => __('Funds Usage', 'wallet-for-woocommerce'),
			'myaccount' => __('My Account', 'wallet-for-woocommerce'),
			'dashboard' => __('Wallet Dashboard', 'wallet-for-woocommerce'),
			'transactions' => __('Transactions', 'wallet-for-woocommerce'),
		);
		/**
		 * This hook is used to alter the localization tab sections.
		 * 
		 * @since 1.0
		 */
		return apply_filters($this->get_plugin_slug() . '_get_sections_' . $this->get_id(), $sections);
	}

	/**
	 * Get the settings for general section array.
	 * 
	 * @return array
	 */
	protected function general_section_array() {
		$section_fields = array();

		// Topup form labels section start
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Top-up Form Labels', 'wallet-for-woocommerce'),
			'id' => 'wal_topup_form_labels_options',
		);
		$section_fields[] = array(
			'title' => __('Top-up Form Title', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Add Funds to Wallet',
			'autoload' => false,
			'id' => $this->get_option_key('topup_title_label'),
		);
		$section_fields[] = array(
			'title' => __('Top-up Amount Placeholder Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Enter the Amount',
			'autoload' => false,
			'id' => $this->get_option_key('topup_placeholder_label'),
		);
		$section_fields[] = array(
			'title' => __('Add to Wallet Button Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Add to Wallet',
			'autoload' => false,
			'id' => $this->get_option_key('topup_button_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_topup_form_labels_options',
		);
		// Topup form labels section end.

		return $section_fields;
	}

	/**
	 * Get the settings for fund usage section array.
	 * 
	 * @return array
	 */
	protected function fund_usage_section_array() {
		$section_fields = array();
		// Fund usage section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Funds Usage Labels', 'wallet-for-woocommerce'),
			'id' => 'wal_fund_usage_options',
		);
		$section_fields[] = array(
			'title' => __('Redeeming Funds Field Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Redeem Your Wallet Funds',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_title_label'),
		);
		$section_fields[] = array(
			'title' => __('Redeeming Funds Field Placeholder Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Enter the Funds',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_placeholder_label'),
		);
		$section_fields[] = array(
			'title' => __('Redeeming Funds Button Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Apply Wallet Funds',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_button_label'),
		);
		$section_fields[] = array(
			'title' => __('Redeeming Funds Field Label - Checkout', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Have Funds?',
			'autoload' => false,
			'id' => $this->get_option_key('checkout_partial_fund_title_label'),
		);
		$section_fields[] = array(
			'title' => __('Redeeming Funds Link Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Click here to use your wallet funds',
			'autoload' => false,
			'id' => $this->get_option_key('checkout_partial_fund_link_label'),
		);
		$section_fields[] = array(
			'title' => __('Remove Link Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => '[Remove]',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_remove_button_label'),
			'desc' => __('<b>{Remove}</b> - Remove link label,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Discount Fee Label[Partial Payment]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Credits',
			'autoload' => false,
			'id' => $this->get_option_key('partial_fund_fee_title_label'),
		);
		$section_fields[] = array(
			'title' => __('Discount Fee Label[Wallet Payment Gateway]', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Discount',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_discount_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_fund_usage_options',
		);
		// Fund usage section end.

		return $section_fields;
	}

	/**
	 * Get the settings for my account section array.
	 * 
	 * @return array
	 */
	protected function myaccount_section_array() {
		$section_fields = array();

		// Myaccount endpoints section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Wallet Endpoints', 'wallet-for-woocommerce'),
			'id' => 'wal_myaccount_endpoints_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Page URL Endpoint', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'wallet',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_menu_endpoint'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_myaccount_endpoints_options',
		);
		// Myaccount endpoints section end.
		// Myaccount label section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Wallet Menu Labels', 'wallet-for-woocommerce'),
			'id' => 'wal_myaccount_label_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Menu Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_menu_name_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Balance Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet balance:',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_balance_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Status Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Status',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_status_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Usage Total Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Total Amount Spent on Purchase',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_usage_total_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Expiry Date Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Expiry date',
			'autoload' => false,
			'id' => $this->get_option_key('myaccount_wallet_expiry_date_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_myaccount_label_options',
		);
		// Myaccount label section end.

		return $section_fields;
	}

	/**
	 * Get the settings for dashboard section array.
	 * 
	 * @return array
	 */
	protected function dashboard_section_array() {
		$section_fields = array();

		// Dashboard endpoints section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Dashboard Endpoints', 'wallet-for-woocommerce'),
			'id' => 'wal_dashboard_endpoints_options',
		);
		$section_fields[] = array(
			'title' => __('Overview Endpoint', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'overview',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_overview_endpoint'),
		);
		$section_fields[] = array(
			'title' => __('Activity Endpoint', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'activity',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_activity_endpoint'),
		);
		$section_fields[] = array(
			'title' => __('Top-up Endpoint', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'topup',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_topup_endpoint'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_dashboard_endpoints_options',
		);
		// Dashboard endpoints section end.
		// Dashboard labels section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Wallet Dashboard Labels', 'wallet-for-woocommerce'),
			'id' => 'wal_dashboard_label_options',
		);
		$section_fields[] = array(
			'title' => __('Overview Menu Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Overview',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_overview_menu_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Activity Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Activity',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_activity_menu_label'),
		);
		$section_fields[] = array(
			'title' => __('Top-up Form Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Top-up Form',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_topup_form_menu_label'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Balance Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Balance:',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_balance_label'),
		);
		$section_fields[] = array(
			'title' => __('Expiry Date Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Expiry Date:',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_expiry_date_label'),
		);
		$section_fields[] = array(
			'title' => __('Total Spent Amount Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Total Spent Amount',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_usage_total_label'),
		);
		$section_fields[] = array(
			'title' => __('Total Top-up Amount Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Total Top-up Amount',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_topup_total_label'),
		);
		$section_fields[] = array(
			'title' => __('Total Expired Amount Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Total Expired Amount',
			'autoload' => false,
			'id' => $this->get_option_key('dashboard_expired_total_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_dashboard_label_options',
		);
		// Dashboard label section end.
		// Dashboard wallet activity label section start.
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Wallet Activity Labels', 'wallet-for-woocommerce'),
			'id' => 'wal_dashboard_wallet_activity_label_options',
		);
		$section_fields[] = array(
			'title' => __('Event Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Event',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_activity_event_label'),
		);
		$section_fields[] = array(
			'title' => __('Amount Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Amount',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_activity_amount_label'),
		);
		$section_fields[] = array(
			'title' => __('Available Balance Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Available Balance',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_activity_total_label'),
		);
		$section_fields[] = array(
			'title' => __('Date Label', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Date',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_activity_date_label'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_dashboard_wallet_activity_label_options',
		);
		// Dashboard wallet activity label section end.

		return $section_fields;
	}

	/**
	 * Get the settings for transactions label section array.
	 * 
	 * @return array
	 */
	protected function transactions_section_array() {
		$section_fields = array();

		// Transactions label section start
		$section_fields[] = array(
			'type' => 'title',
			'title' => __('Transaction Log', 'wallet-for-woocommerce'),
			'id' => 'wal_transaction_log_label_options',
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up - Credited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Top-up Successful on Order {order_id}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_fund_credit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up - Debited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds added to your wallet through top-up have been debited because the order {order_id} got {order_status}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_fund_debit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,</br><b>{order_status}</b> - It will display the order status,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up Bonus - Credited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Top-up bonus Successful on Order {order_id}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_bonus_fund_credit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Top-up Bonus - Debited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds added to your wallet through top-up bonus have been debited because the order {order_id} got {order_status}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_topup_bonus_fund_debit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,</br><b>{order_status}</b> - It will display the order status,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Partial Wallet Usage - Debited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Funds used on Order {order_id}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_partial_fund_debit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Partial Wallet Usage - Revised Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Funds used in the Order {order_id} has been revised to the account',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_partial_fund_credit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Usage through Payment Gateway - Debited Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Wallet Gateway used on Order {order_id}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_payment_gateway_debit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Usage through Payment Gateway - Revised Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds have been Credited on your Wallet because the order {order_id} got {order_status}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_payment_gateway_credit_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,</br><b>{order_status}</b> - It will display the order status,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Expired Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds debited due to wallet expiry',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_expired_log'),
		);
		$section_fields[] = array(
			'title' => __('Wallet Refund Log', 'wallet-for-woocommerce'),
			'type' => 'textarea',
			'default' => 'Funds Refunded to the Order {order_id}',
			'autoload' => false,
			'id' => $this->get_option_key('wallet_refund_log'),
			'desc' => __('<b>{order_id}</b> - It will display the order id,', 'wallet-for-woocommerce'),
		);
		$section_fields[] = array(
			'type' => 'sectionend',
			'id' => 'wal_transaction_log_label_options',
		);
		// Transactions label section end

		return $section_fields;
	}
}

return new WAL_Localization_Tab();
